package mezz.jei.gui.elements;

import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_8666;
import net.minecraft.class_9848;

public final class ButtonSprites {
	private final class_8666 widgetSprites;
	private final IScalableDrawable pressed;
	private final IScalableDrawable pressedFocused;

	public ButtonSprites() {
		this.widgetSprites = new class_8666(
			class_2960.method_60656("widget/button"),
			class_2960.method_60656("widget/button_disabled"),
			class_2960.method_60656("widget/button_highlighted")
		);
		Textures textures = Internal.getTextures();
		this.pressed = textures.getButtonPressed();
		this.pressedFocused = textures.getButtonPressedHighlight();
	}

	public void render(class_332 guiGraphics, boolean enabled, boolean focused, boolean pressed, int x, int y, int width, int height, int alpha) {
		if (pressed) {
			if (focused) {
				this.pressedFocused.draw(guiGraphics, x, y, width, height);
			} else {
				this.pressed.draw(guiGraphics, x, y, width, height);
			}
		} else {
			class_2960 spriteLocation = widgetSprites.method_52729(enabled, focused);
			guiGraphics.method_52707(class_10799.field_56883, spriteLocation, x, y, width, height, class_9848.method_75612(alpha));
		}
	}
}
