package mezz.jei.gui.bookmarks;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.class_5455;
import net.minecraft.class_6903;

public class BookmarkFactory {
	private final Codec<ITypedIngredient<?>> typedIngredientCodec;
	private final class_6903<JsonElement> serializationContext;
	private final IIngredientManager ingredientManager;

	public BookmarkFactory(ICodecHelper codecHelper, class_5455 registryAccess, IIngredientManager ingredientManager) {
		this.typedIngredientCodec = codecHelper.getTypedIngredientCodec().codec();
		this.serializationContext = registryAccess.method_57093(JsonOps.INSTANCE);
		this.ingredientManager = ingredientManager;
	}

	public <T> IngredientBookmark<T> create(ITypedIngredient<T> typedIngredient) {
		typedIngredient = ingredientManager.normalizeTypedIngredient(typedIngredient);

		Object bookmarkUid = typedIngredientCodec.encodeStart(serializationContext, typedIngredient)
			.result()
			.orElse(JsonNull.INSTANCE)
			.toString(); // JsonElement is slow for hash/equals, so use the string representation as the uid

		return new IngredientBookmark<>(typedIngredient, bookmarkUid);
	}
}
