/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.recipes.RecipesGui;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButtonController
implements IIconButtonController {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final RecipesGui recipesGui;
    @Nullable
    private IRecipeTransferError recipeTransferError;

    public RecipeTransferButtonController(IRecipeLayoutDrawable<?> recipeLayout, RecipesGui recipesGui) {
        this.recipeLayout = recipeLayout;
        this.recipesGui = recipesGui;
    }

    @Override
    public void initState(IButtonState state) {
        Textures textures = Internal.getTextures();
        state.setIcon(textures.getRecipeTransfer());
        this.updateState(state);
    }

    @Override
    public void updateState(IButtonState state) {
        class_746 player = class_310.method_1551().field_1724;
        class_1703 parentContainer = this.recipesGui.getParentContainerMenu();
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, this.recipeLayout, (class_1657)player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            state.setActive(true);
            state.setVisible(true);
        } else {
            state.setActive(false);
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            state.setVisible(type == IRecipeTransferError.Type.USER_FACING);
        }
    }

    @Override
    public boolean onPress(IJeiUserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            class_310 minecraft = class_310.method_1551();
            boolean maxTransfer = minecraft.method_74187();
            class_746 player = minecraft.field_1724;
            class_1703 parentContainer = this.recipesGui.getParentContainerMenu();
            if (parentContainer != null && player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, parentContainer, this.recipeLayout, (class_1657)player, maxTransfer)) {
                this.recipesGui.method_25419();
            }
        }
        return true;
    }

    @Override
    public void getTooltips(ITooltipBuilder tooltip) {
        if (this.recipeTransferError == null) {
            class_5250 tooltipTransfer = class_2561.method_43471((String)"jei.tooltip.transfer");
            tooltip.add((class_5348)tooltipTransfer);
        } else {
            this.recipeTransferError.getTooltip(tooltip);
        }
    }

    @Override
    public void drawExtras(class_332 guiGraphics, class_768 buttonArea, int mouseX, int mouseY, float partialTicks) {
        IRecipeTransferError recipeTransferError = this.recipeTransferError;
        if (recipeTransferError != null) {
            if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                guiGraphics.method_25294(buttonArea.method_3321(), buttonArea.method_3322(), buttonArea.method_3321() + buttonArea.method_3319(), buttonArea.method_3322() + buttonArea.method_3320(), recipeTransferError.getButtonHighlightColor());
            }
            if (buttonArea.method_3318(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                class_768 recipeRect = this.recipeLayout.getRect();
                recipeTransferError.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeRect.method_3321(), recipeRect.method_3322());
            }
        }
    }

    public int getMissingCountHint() {
        if (this.recipeTransferError == null) {
            return 0;
        }
        return this.recipeTransferError.getMissingCountHint();
    }
}

