package mezz.jei.common.gui.elements;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8029;
import org.jspecify.annotations.Nullable;

import java.util.List;

public class TextWidget implements ITextWidget, IRecipeWidget {
	private final List<class_5348> text;
	private ImmutableRect2i availableArea;

	private HorizontalAlignment horizontalAlignment;
	private VerticalAlignment verticalAlignment;
	private class_327 font;
	private int color;
	private boolean shadow;
	private int lineSpacing;

	private @Nullable List<class_5348> wrappedText;
	private boolean truncated = false;

	public TextWidget(List<class_5348> text, int xPos, int yPos, int maxWidth, int maxHeight) {
		this.availableArea = new ImmutableRect2i(xPos, yPos, maxWidth, maxHeight);
		class_310 minecraft = class_310.method_1551();
		this.font = minecraft.field_1772;
		this.color = 0xFF000000;
		this.text = text;
		this.lineSpacing = 2;
		this.horizontalAlignment = HorizontalAlignment.LEFT;
		this.verticalAlignment = VerticalAlignment.TOP;
	}

	private void invalidateCachedValues() {
		wrappedText = null;
		truncated = false;
	}

	@Override
	public int getWidth() {
		return availableArea.width();
	}

	@Override
	public int getHeight() {
		return availableArea.height();
	}

	@Override
	public TextWidget setPosition(int xPos, int yPos) {
		this.availableArea = this.availableArea.setPosition(xPos, yPos);
		invalidateCachedValues();
		return this;
	}

	@Override
	public TextWidget setTextAlignment(HorizontalAlignment horizontalAlignment) {
		if (this.horizontalAlignment.equals(horizontalAlignment)) {
			return this;
		}
		this.horizontalAlignment = horizontalAlignment;
		invalidateCachedValues();
		return this;
	}

	@Override
	public TextWidget setTextAlignment(VerticalAlignment verticalAlignment) {
		if (this.verticalAlignment.equals(verticalAlignment)) {
			return this;
		}
		this.verticalAlignment = verticalAlignment;
		invalidateCachedValues();
		return this;
	}

	@Override
	public ITextWidget setFont(class_327 font) {
		this.font = font;
		invalidateCachedValues();
		return this;
	}

	@Override
	public ITextWidget setColor(int color) {
		this.color = color;
		invalidateCachedValues();
		return this;
	}

	@Override
	public ITextWidget setLineSpacing(int lineSpacing) {
		this.lineSpacing = lineSpacing;
		invalidateCachedValues();
		return this;
	}

	@Override
	public ITextWidget setShadow(boolean shadow) {
		this.shadow = shadow;
		invalidateCachedValues();
		return this;
	}

	@Override
	public class_8029 getPosition() {
		return availableArea.getScreenPosition();
	}

	private List<class_5348> calculateWrappedText() {
		if (wrappedText != null) {
			return wrappedText;
		}
		int lineHeight = getLineHeight();
		int maxLines = availableArea.height() / lineHeight;
		if (maxLines * lineHeight + font.field_2000 <= availableArea.height()) {
			maxLines++;
		}
		Pair<List<class_5348>, Boolean> result = StringUtil.splitLines(font, text, availableArea.width(), maxLines);
		this.wrappedText = result.first();
		this.truncated = result.second();
		return wrappedText;
	}

	private int getLineHeight() {
		return font.field_2000 + lineSpacing;
	}

	@Override
	public void drawWidget(class_332 guiGraphics, double mouseX, double mouseY) {
		class_2477 language = class_2477.method_10517();

		final int lineHeight = getLineHeight();
		List<class_5348> lines = calculateWrappedText();
		int yPos = getYPosStart(lineHeight, lines);
		for (class_5348 line : lines) {
			class_5481 charSequence = language.method_30934(line);
			int xPos = getXPos(charSequence);
			guiGraphics.method_51430(font, charSequence, xPos, yPos, color, shadow);
			yPos += lineHeight;
		}

		if (DebugConfig.isDebugGuisEnabled()) {
			guiGraphics.method_25294(0,0, availableArea.width(), availableArea.height(), 0xAAAAAA00);
		}
	}

	@Override
	public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
		if (mouseX >= 0 && mouseX < availableArea.width() && mouseY >= 0 && mouseY < availableArea.height()) {
			calculateWrappedText();
			if (truncated) {
				tooltip.addAll(text);
			}
		}
	}

	private int getXPos(class_5481 text) {
		return getXPos(font.method_30880(text));
	}

	private int getXPos(int lineWidth) {
		return horizontalAlignment.getXPos(this.availableArea.width(), lineWidth);
	}

	private int getYPosStart(int lineHeight, List<class_5348> text) {
		int linesHeight = (lineHeight * text.size()) - lineSpacing - 1;
		return verticalAlignment.getYPos(this.availableArea.height(), linesHeight);
	}
}
