package mezz.jei.library.plugins.vanilla.anvil;

import com.mojang.serialization.Codec;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_2246;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import org.jspecify.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SmithingRecipeCategory extends AbstractRecipeCategory<class_8786<class_8059>> implements IExtendableSmithingRecipeCategory {
	private final Map<Class<? extends class_8059>, ISmithingCategoryExtension<?>> extensions = new HashMap<>();

	public SmithingRecipeCategory(IGuiHelper guiHelper) {
		super(
			RecipeTypes.SMITHING,
			class_2246.field_16329.method_9518(),
			guiHelper.createDrawableItemLike(class_2246.field_16329),
			108,
			28
		);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_8059> recipeHolder, IFocusGroup focuses) {
		class_8059 recipe = recipeHolder.comp_1933();

		ISmithingCategoryExtension<? super class_8059> extension = getExtension(recipe);
		if (extension == null) {
			return;
		}

		IRecipeSlotBuilder templateSlot = builder.addInputSlot(1, 6)
			.setStandardSlotBackground();

		IRecipeSlotBuilder baseSlot = builder.addInputSlot(19, 6)
			.setStandardSlotBackground();

		IRecipeSlotBuilder additionSlot = builder.addInputSlot(37, 6)
			.setStandardSlotBackground();

		IRecipeSlotBuilder outputSlot = builder.addOutputSlot(91, 6)
			.setStandardSlotBackground();

		extension.setTemplate(recipe, templateSlot);
		extension.setBase(recipe, baseSlot);
		extension.setAddition(recipe, additionSlot);
		extension.setOutput(recipe, outputSlot);
	}

	@Override
	public void onDisplayedIngredientsUpdate(class_8786<class_8059> recipeHolder, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
		class_8059 recipe = recipeHolder.comp_1933();
		ISmithingCategoryExtension<? super class_8059> extension = getExtension(recipe);
		if (extension == null) {
			return;
		}

		IRecipeSlotDrawable templateSlot = recipeSlots.getFirst();
		IRecipeSlotDrawable baseSlot = recipeSlots.get(1);
		IRecipeSlotDrawable additionSlot = recipeSlots.get(2);
		IRecipeSlotDrawable outputSlot = recipeSlots.get(3);
		extension.onDisplayedIngredientsUpdate(
			recipe,
			templateSlot,
			baseSlot,
			additionSlot,
			outputSlot,
			focuses
		);
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8786<class_8059> recipe, IFocusGroup focuses) {
		builder.addRecipeArrow().setPosition(61, 6);
	}

	@Override
	public Codec<class_8786<class_8059>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
		return codecHelper.getRecipeHolderCodec();
	}

	@Override
	public <R extends class_8059> void addExtension(Class<? extends R> recipeClass, ISmithingCategoryExtension<R> extension) {
		ErrorUtil.checkNotNull(recipeClass, "recipeClass");
		ErrorUtil.checkNotNull(extension, "extension");
		if (extensions.containsKey(recipeClass)) {
			throw new IllegalArgumentException("An extension has already been registered for: " + recipeClass);
		}
		extensions.put(recipeClass, extension);
	}

	@Nullable
	private <R extends class_8059> ISmithingCategoryExtension<? super R> getExtension(class_8059 recipe) {
		{
			ISmithingCategoryExtension<?> extension = extensions.get(recipe.getClass());
			if (extension != null) {
				@SuppressWarnings("unchecked")
				ISmithingCategoryExtension<? super R> cast = (ISmithingCategoryExtension<? super R>) extension;
				return cast;
			}
		}
		for (Map.Entry<Class<? extends class_8059>, ISmithingCategoryExtension<?>> e : extensions.entrySet()) {
			if (e.getKey().isInstance(recipe)) {
				@SuppressWarnings("unchecked")
				ISmithingCategoryExtension<? super R> cast = (ISmithingCategoryExtension<? super R>) e.getValue();
				return cast;
			}
		}
		return null;
	}
}
