package mezz.jei.gui.ghost;

import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.IClientToggleState;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IClickableIngredientInternal;
import mezz.jei.gui.input.IDragHandler;
import mezz.jei.gui.input.IDraggableIngredientInternal;
import mezz.jei.gui.input.IRecipeFocusSource;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jspecify.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GhostIngredientDragManager {
	private final IRecipeFocusSource source;
	private final IScreenHelper screenHelper;
	private final IIngredientManager ingredientManager;
	private final IClientToggleState toggleState;
	private final List<GhostIngredientReturning<?>> ghostIngredientsReturning = new ArrayList<>();
	@Nullable
	private GhostIngredientDrag<?> ghostIngredientDrag;
	@Nullable
	private ITypedIngredient<?> hoveredIngredient;
	private List<class_768> hoveredTargetAreas = List.of();

	public GhostIngredientDragManager(
		IRecipeFocusSource source,
		IScreenHelper screenHelper,
		IIngredientManager ingredientManager,
		IClientToggleState toggleState
	) {
		this.source = source;
		this.screenHelper = screenHelper;
		this.ingredientManager = ingredientManager;
		this.toggleState = toggleState;
	}

	public void drawTooltips(class_310 minecraft, class_332 guiGraphics, int mouseX, int mouseY) {
		if (!(minecraft.field_1755 instanceof class_465)) { // guiContainer uses drawOnForeground
			drawGhostIngredientHighlights(guiGraphics, mouseX, mouseY);
		}
		if (ghostIngredientDrag != null) {
			ghostIngredientDrag.drawItem(guiGraphics, mouseX, mouseY);
		}
		ghostIngredientsReturning.forEach(returning -> returning.drawItem(guiGraphics));
		ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
	}

	public void drawOnForeground(class_332 guiGraphics, int mouseX, int mouseY) {
		drawGhostIngredientHighlights(guiGraphics, mouseX, mouseY);
	}

	private void drawGhostIngredientHighlights(class_332 guiGraphics, int mouseX, int mouseY) {
		if (this.ghostIngredientDrag != null) {
			this.ghostIngredientDrag.drawTargets(guiGraphics, mouseX, mouseY);
		} else {
			ITypedIngredient<?> hovered = this.source.getIngredientUnderMouse(mouseX, mouseY)
				.map(IClickableIngredientInternal::getTypedIngredient)
				.findFirst()
				.orElse(null);
			if (!equals(hovered, this.hoveredIngredient)) {
				this.hoveredIngredient = hovered;
				this.hoveredTargetAreas = getHoveredTargetAreas(hovered);
			}
			if (!this.hoveredTargetAreas.isEmpty() && !toggleState.isCheatItemsEnabled()) {
				GhostIngredientDrag.drawTargets(guiGraphics, mouseX, mouseY, this.hoveredTargetAreas);
			}
		}
	}

	private List<class_768> getHoveredTargetAreas(@Nullable ITypedIngredient<?> hovered) {
		if (hovered == null) {
			return List.of();
		}
		class_310 minecraft = class_310.method_1551();
		class_437 currentScreen = minecraft.field_1755;
		if (currentScreen == null) {
			return List.of();
		}
		List<class_768> targetAreas = new ArrayList<>();
		List<IGhostIngredientHandler<class_437>> handlers = screenHelper.getGhostIngredientHandlers(currentScreen);
		for (IGhostIngredientHandler<class_437> handler : handlers) {
			if (!handler.shouldHighlightTargets()) {
				continue;
			}
			List<? extends IGhostIngredientHandler.Target<?>> targets = handler.getTargetsTyped(currentScreen, hovered, false);
			for (IGhostIngredientHandler.Target<?> target : targets) {
				class_768 area = target.getArea();
				targetAreas.add(area);
			}
		}
		return targetAreas;
	}

	private static boolean equals(@Nullable ITypedIngredient<?> a, @Nullable ITypedIngredient<?> b) {
		if (a == b) {
			return true;
		}
		if (a == null || b == null) {
			return false;
		}
		return a.getIngredient() == b.getIngredient();
	}

	public void stopDrag() {
		if (this.ghostIngredientDrag != null) {
			this.ghostIngredientDrag.stop();
			this.ghostIngredientDrag = null;
		}
		this.hoveredIngredient = null;
		this.hoveredTargetAreas = List.of();
	}

	private <T extends class_437, V> boolean handleClickGhostIngredient(T currentScreen, IDraggableIngredientInternal<V> clicked, UserInput input) {
		List<IGhostIngredientHandler<T>> handlers = screenHelper.getGhostIngredientHandlers(currentScreen);

		List<GhostIngredientDrag.HandlerData<V>> handlerDataList = new ArrayList<>();
		for (IGhostIngredientHandler<T> handler : handlers) {
			ITypedIngredient<V> ingredient = clicked.getTypedIngredient();
			List<IGhostIngredientHandler.Target<V>> targets = handler.getTargetsTyped(currentScreen, ingredient, true);
			if (!targets.isEmpty()) {
				handlerDataList.add(new GhostIngredientDrag.HandlerData<>(handler, targets));
			}
		}

		if (handlerDataList.isEmpty()) {
			return false;
		}

		ITypedIngredient<V> ingredient = clicked.getTypedIngredient();
		IIngredientType<V> type = ingredient.getType();
		IIngredientRenderer<V> ingredientRenderer = ingredientManager.getIngredientRenderer(type);
		ImmutableRect2i clickedArea = clicked.getArea();
		this.ghostIngredientDrag = new GhostIngredientDrag<>(handlerDataList, ingredientRenderer, ingredient, input.getMouseX(), input.getMouseY(), clickedArea);
		return true;
	}

	public IDragHandler createDragHandler() {
		return new DragHandler();
	}

	private class DragHandler implements IDragHandler {
		@Override
		public Optional<IDragHandler> handleDragStart(class_437 screen, UserInput input) {
			class_310 minecraft = class_310.method_1551();
			class_746 player = minecraft.field_1724;
			if (player == null) {
				return Optional.empty();
			}

			return source.getDraggableIngredientUnderMouse(input.getMouseX(), input.getMouseY())
				.findFirst()
				.flatMap(clicked -> {
					class_1799 mouseItem = player.field_7512.method_34255();
					if (mouseItem.method_7960() &&
						handleClickGhostIngredient(screen, clicked, input)) {
						return Optional.of(this);
					}
					return Optional.empty();
				});
		}

		@Override
		public boolean handleDragComplete(class_437 screen, UserInput input) {
			if (ghostIngredientDrag == null) {
				return false;
			}
			boolean success = ghostIngredientDrag.onClick(input);
			double mouseX = input.getMouseX();
			double mouseY = input.getMouseY();
			if (!success && GhostIngredientDrag.canStart(ghostIngredientDrag, mouseX, mouseY)) {
				GhostIngredientReturning.create(ghostIngredientDrag, mouseX, mouseY)
					.ifPresent(ghostIngredientsReturning::add);
			}
			ghostIngredientDrag = null;
			hoveredTargetAreas = List.of();
			return success;
		}

		@Override
		public void handleDragCanceled() {
			stopDrag();
		}
	}
}
