package mezz.jei.library.plugins.debug;

import mezz.jei.api.constants.ModIds;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class DebugFocusRecipeCategory<F> implements IRecipeCategory<DebugRecipe> {
	public static final IRecipeType<DebugRecipe> TYPE = IRecipeType.create(ModIds.JEI_ID, "debug_focus", DebugRecipe.class);
	public static final int RECIPE_WIDTH = 160;
	public static final int RECIPE_HEIGHT = 60;
	private final IPlatformFluidHelper<F> platformFluidHelper;
	private final class_2561 localizedName;

	public DebugFocusRecipeCategory(IPlatformFluidHelper<F> platformFluidHelper) {
		this.platformFluidHelper = platformFluidHelper;
		this.localizedName = class_2561.method_43470("debug_focus");
	}

	@Override
	public IRecipeType<DebugRecipe> getRecipeType() {
		return TYPE;
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public int getWidth() {
		return RECIPE_WIDTH;
	}

	@Override
	public int getHeight() {
		return RECIPE_HEIGHT;
	}

	@Override
	@Nullable
	public IDrawable getIcon() {
		return null;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
		IRecipeSlotBuilder inputSlot = builder.addInputSlot(0, 0)
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8550),
				new class_1799(class_1802.field_8705),
				new class_1799(class_1802.field_8187),
				new class_1799(class_1802.field_27876),
				new class_1799(class_1802.field_28354),
				new class_1799(class_1802.field_8714),
				new class_1799(class_1802.field_8666),
				new class_1799(class_1802.field_8108),
				new class_1799(class_1802.field_8478)
			));

		long bucketVolume = platformFluidHelper.bucketVolume();
		IRecipeSlotBuilder outputSlot = builder.addOutputSlot(20, 0)
			.add(class_1799.field_8037)
			.addIngredients(platformFluidHelper.getFluidIngredientType(), List.of(
				platformFluidHelper.create(class_3612.field_15910.method_15785().method_40180(), bucketVolume),
				platformFluidHelper.create(class_3612.field_15908.method_15785().method_40180(), bucketVolume)
			))
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8246),
				new class_1799(class_1802.field_28355),
				new class_1799(class_1802.field_8209),
				new class_1799(class_1802.field_8429),
				new class_1799(class_1802.field_8323),
				new class_1799(class_1802.field_8846)
			));

		builder.addInvisibleIngredients(RecipeIngredientRole.INPUT)
			.addItemStacks(List.of(
				new class_1799(class_1802.field_8094),
				new class_1799(class_1802.field_8605),
				new class_1799(class_1802.field_8758),
				new class_1799(class_1802.field_8820),
				new class_1799(class_1802.field_8651),
				new class_1799(class_1802.field_8646),
				new class_1799(class_1802.field_8114),
				new class_1799(class_1802.field_17507),
				new class_1799(class_1802.field_8173)
			));

		builder.createFocusLink(inputSlot, outputSlot);
	}

	@Override
	public class_2960 getIdentifier(DebugRecipe recipe) {
		return recipe.getId();
	}
}
