/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;

public final class VanillaRecipes {
    private final RecipeMap syncedRecipes;

    public VanillaRecipes(RecipeMap syncedRecipes) {
        this.syncedRecipes = syncedRecipes;
    }

    public CraftingRecipes getCraftingRecipes(IRecipeCategory<RecipeHolder<CraftingRecipe>> craftingCategory) {
        CraftingRecipes result = new CraftingRecipes();
        Collection craftingRecipes = this.syncedRecipes.byType(RecipeType.CRAFTING);
        for (RecipeHolder recipe : craftingRecipes) {
            if (craftingCategory.isHandled((Object)recipe)) {
                result.handled.add((RecipeHolder<CraftingRecipe>)recipe);
                continue;
            }
            result.unhandled.add((RecipeHolder<CraftingRecipe>)recipe);
        }
        return result;
    }

    public List<RecipeHolder<StonecutterRecipe>> getStonecuttingRecipes(IRecipeCategory<RecipeHolder<StonecutterRecipe>> stonecuttingCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.STONECUTTING, stonecuttingCategory);
    }

    public List<RecipeHolder<SmeltingRecipe>> getFurnaceRecipes(IRecipeCategory<RecipeHolder<SmeltingRecipe>> furnaceCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.SMELTING, furnaceCategory);
    }

    public List<RecipeHolder<SmokingRecipe>> getSmokingRecipes(IRecipeCategory<RecipeHolder<SmokingRecipe>> smokingCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.SMOKING, smokingCategory);
    }

    public List<RecipeHolder<BlastingRecipe>> getBlastingRecipes(IRecipeCategory<RecipeHolder<BlastingRecipe>> blastingCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.BLASTING, blastingCategory);
    }

    public List<RecipeHolder<CampfireCookingRecipe>> getCampfireCookingRecipes(IRecipeCategory<RecipeHolder<CampfireCookingRecipe>> campfireCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.CAMPFIRE_COOKING, campfireCategory);
    }

    public List<RecipeHolder<SmithingRecipe>> getSmithingRecipes(IRecipeCategory<RecipeHolder<SmithingRecipe>> smithingCategory) {
        return VanillaRecipes.getHandledRecipes(this.syncedRecipes, RecipeType.SMITHING, smithingCategory);
    }

    public static <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getHandledRecipes(RecipeMap syncedRecipes, RecipeType<T> recipeType, IRecipeCategory<RecipeHolder<T>> recipeCategory) {
        return syncedRecipes.byType(recipeType).stream().filter(arg_0 -> recipeCategory.isHandled(arg_0)).toList();
    }

    public static class CraftingRecipes {
        private final List<RecipeHolder<CraftingRecipe>> handled = new ArrayList<RecipeHolder<CraftingRecipe>>();
        private final List<RecipeHolder<CraftingRecipe>> unhandled = new ArrayList<RecipeHolder<CraftingRecipe>>();

        public List<RecipeHolder<CraftingRecipe>> getHandled() {
            return Collections.unmodifiableList(this.handled);
        }

        public List<RecipeHolder<CraftingRecipe>> getUnhandled() {
            return Collections.unmodifiableList(this.unhandled);
        }
    }
}

