/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.recipes;

import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.library.recipes.collect.RecipeIngredientRoleMap;

public class CraftingStationBuilder {
    private final ImmutableListMultimap.Builder<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsBuilder = ImmutableListMultimap.builder();
    private final RecipeIngredientRoleMap craftingStationMap;

    public CraftingStationBuilder(RecipeIngredientRoleMap craftingStationMap) {
        this.craftingStationMap = craftingStationMap;
    }

    public void addCategoryCatalysts(IRecipeCategory<?> recipeCategory, List<ITypedIngredient<?>> categoryCatalystIngredients) {
        this.recipeCategoryCatalystsBuilder.putAll(recipeCategory, categoryCatalystIngredients);
        for (ITypedIngredient<?> catalystIngredient : categoryCatalystIngredients) {
            this.addCategoryCatalyst(catalystIngredient, recipeCategory);
        }
    }

    private <T> void addCategoryCatalyst(ITypedIngredient<T> catalystIngredient, IRecipeCategory<?> recipeCategory) {
        IRecipeType recipeType = recipeCategory.getRecipeType();
        this.craftingStationMap.addCraftingStationForCategory(recipeType, catalystIngredient);
    }

    public ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> build() {
        return this.recipeCategoryCatalystsBuilder.build();
    }
}

