/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Either;
import mezz.jei.common.input.KeyNameUtil;
import mezz.jei.common.input.MouseButtonEventData;
import mezz.jei.gui.input.InputType;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.util.StringUtil;

public class KeyUserInput
extends UserInput {
    private final InputConstants.Key key;
    private final KeyEvent event;
    private final double mouseX;
    private final double mouseY;
    private final InputType inputType;

    public KeyUserInput(KeyEvent event, InputType inputType) {
        this.key = InputConstants.getKey((KeyEvent)event);
        this.event = event;
        this.mouseX = MouseUtil.getX();
        this.mouseY = MouseUtil.getY();
        this.inputType = inputType;
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    @Override
    public double getMouseX() {
        return this.mouseX;
    }

    @Override
    public double getMouseY() {
        return this.mouseY;
    }

    @Override
    public InputType getInputType() {
        return this.inputType;
    }

    public int getModifiers() {
        return this.event.modifiers();
    }

    public boolean isSimulate() {
        return this.inputType == InputType.SIMULATE;
    }

    @Override
    public boolean isAllowedChatCharacter() {
        return StringUtil.isAllowedChatCharacter((int)((char)this.key.getValue()));
    }

    @Override
    public Either<MouseButtonEventData, KeyEvent> getEvent() {
        return Either.right((Object)this.event);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("inputType", (Object)this.inputType).add("key", (Object)KeyNameUtil.getKeyDisplayName((InputConstants.Key)this.key).getString()).add("event", (Object)this.event).add("mouse", (Object)String.format("%s, %s", this.mouseX, this.mouseY)).toString();
    }
}

