/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.events;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix3x2fStack;

public class GuiEventHandler {
    private final IngredientListOverlay ingredientListOverlay;
    private final IScreenHelper screenHelper;
    private final BookmarkOverlay bookmarkOverlay;

    public GuiEventHandler(IScreenHelper screenHelper, BookmarkOverlay bookmarkOverlay, IngredientListOverlay ingredientListOverlay) {
        this.screenHelper = screenHelper;
        this.bookmarkOverlay = bookmarkOverlay;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void onGuiInit(Screen screen) {
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).updateExclusionAreas(guiExclusionAreas).update();
    }

    public void onGuiOpen(Screen screen) {
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(screen).update();
    }

    public void drawForContainerScreen(AbstractContainerScreen<?> screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        if (guiProperties != null) {
            poseStack.translate((float)(-guiProperties.guiLeft()), (float)(-guiProperties.guiTop()));
            this.bookmarkOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
            this.ingredientListOverlay.drawOnForeground(guiGraphics, mouseX, mouseY);
        }
        this.drawMainContents((Screen)screen, guiProperties, guiGraphics, mouseX, mouseY);
        poseStack.popMatrix();
    }

    public void drawForScreen(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (screen instanceof AbstractContainerScreen) {
            return;
        }
        IGuiProperties guiProperties = this.screenHelper.getGuiProperties(screen).orElse(null);
        this.drawMainContents(screen, guiProperties, guiGraphics, mouseX, mouseY);
    }

    private void drawMainContents(Screen screen, @Nullable IGuiProperties guiProperties, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.getScreenPropertiesUpdater().updateScreen(guiProperties).updateExclusionAreas(guiExclusionAreas).update();
        this.bookmarkOverlay.getScreenPropertiesUpdater().updateScreen(guiProperties).updateExclusionAreas(guiExclusionAreas).update();
        DeltaTracker deltaTracker = minecraft.getDeltaTracker();
        float partialTicks = deltaTracker.getGameTimeDeltaPartialTick(false);
        this.ingredientListOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, partialTicks);
        this.bookmarkOverlay.drawScreen(minecraft, guiGraphics, mouseX, mouseY, partialTicks);
        if (guiProperties != null && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            int guiLeft = guiProperties.guiLeft();
            int guiTop = guiProperties.guiTop();
            this.screenHelper.getGuiClickableArea(guiContainer, (double)(mouseX - guiLeft), (double)(mouseY - guiTop)).filter(IGuiClickableArea::isTooltipEnabled).findFirst().ifPresent(area -> {
                JeiTooltip tooltip = new JeiTooltip();
                area.getTooltip((ITooltipBuilder)tooltip);
                if (tooltip.isEmpty()) {
                    tooltip.add((FormattedText)Component.translatable((String)"jei.tooltip.show.recipes"));
                }
                tooltip.draw(guiGraphics, mouseX, mouseY);
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        this.bookmarkOverlay.drawTooltips(minecraft, guiGraphics, mouseX, mouseY);
        if (DebugConfig.isDebugGuisEnabled()) {
            this.drawDebugInfoForScreen(screen, guiProperties, guiGraphics);
        }
    }

    public boolean renderCompactPotionIndicators() {
        return this.ingredientListOverlay.isListDisplayed();
    }

    private void drawDebugInfoForScreen(Screen screen, @Nullable IGuiProperties guiProperties, GuiGraphics guiGraphics) {
        RectDebugger.INSTANCE.draw(guiGraphics);
        if (guiProperties != null) {
            Set guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).collect(Collectors.toUnmodifiableSet());
            for (Rect2i area : guiExclusionAreas) {
                guiGraphics.fill(area.getX(), area.getY(), area.getX() + area.getWidth(), area.getY() + area.getHeight(), 0x44FF0000);
            }
        } else {
            return;
        }
        guiGraphics.fill(guiProperties.guiLeft(), guiProperties.guiTop(), guiProperties.guiLeft() + guiProperties.guiXSize(), guiProperties.guiTop() + guiProperties.guiYSize(), 0x22CCCC00);
    }
}

