/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.List;
import java.util.Optional;
import mezz.jei.gui.input.IDragHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class DragRouter {
    private final List<IDragHandler> handlers;
    @Nullable
    private IDragHandler dragStartedCallback;

    public DragRouter(IDragHandler ... handlers) {
        this.handlers = List.of(handlers);
    }

    public void handleGuiChange() {
        this.cancelDrag();
    }

    public boolean startDrag(class_437 screen, UserInput input) {
        this.cancelDrag();
        this.dragStartedCallback = this.handlers.stream().map(i -> i.handleDragStart(screen, input)).flatMap(Optional::stream).findFirst().orElse(null);
        return this.dragStartedCallback != null;
    }

    public boolean completeDrag(class_437 screen, UserInput input) {
        if (this.dragStartedCallback == null) {
            return false;
        }
        boolean result = this.dragStartedCallback.handleDragComplete(screen, input);
        this.dragStartedCallback = null;
        return result;
    }

    public void cancelDrag() {
        for (IDragHandler handler : this.handlers) {
            handler.handleDragCanceled();
        }
        this.dragStartedCallback = null;
    }
}

