package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;

public class EnchantedBookSubtypeInterpreter implements ISubtypeInterpreter<class_1799> {
	public static final EnchantedBookSubtypeInterpreter INSTANCE = new EnchantedBookSubtypeInterpreter();

	private EnchantedBookSubtypeInterpreter() {

	}

	@Override
	@Nullable
	public Object getSubtypeData(class_1799 ingredient, UidContext context) {
		return class_1890.method_57532(ingredient);
	}

	public String getStringName(class_1799 itemStack) {
		class_9304 enchantments = class_1890.method_57532(itemStack);
		if (enchantments.method_57543()) {
			return "";
		}
		List<String> strings = new ArrayList<>();
		for (class_6880<class_1887> e : enchantments.method_57534()) {
			Optional<class_5321<class_1887>> enchantmentResourceKey = e.method_40230();
			if (enchantmentResourceKey.isPresent()) {
				String s = enchantmentResourceKey.orElseThrow().method_29177() + ".lvl" + enchantments.method_57536(e);
				strings.add(s);
			}
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}
		return joiner.toString();
	}
}
