/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.color;

import java.util.Arrays;
import mezz.jei.library.color.MMCQ;
import net.minecraft.class_1011;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class ColorThief {
    public static int[][] getPalette(class_1011 sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        MMCQ.CMap cmap = ColorThief.getColorMap(sourceImage, colorCount, quality, ignoreWhite);
        if (cmap == null) {
            return new int[0][0];
        }
        return cmap.palette();
    }

    @Nullable
    public static MMCQ.CMap getColorMap(class_1011 sourceImage, int colorCount, int quality, boolean ignoreWhite) {
        if (sourceImage.method_4318() == class_1011.class_1012.field_4997) {
            int[][] pixelArray = ColorThief.getPixels(sourceImage, quality, ignoreWhite);
            return MMCQ.quantize(pixelArray, colorCount);
        }
        return null;
    }

    private static int[][] getPixels(class_1011 sourceImage, int quality, boolean ignoreWhite) {
        int width = sourceImage.method_4307();
        int height = sourceImage.method_4323();
        int pixelCount = width * height;
        int numRegardedPixels = (pixelCount + quality - 1) / quality;
        int numUsedPixels = 0;
        int[][] pixelArray = new int[numRegardedPixels][];
        int i = 0;
        while (i < pixelCount) {
            int x = i % width;
            int y = i / width;
            int pixel = sourceImage.method_61940(x, y);
            int a = class_9848.method_61320((int)pixel);
            int b = class_9848.method_61331((int)pixel);
            int g = class_9848.method_61329((int)pixel);
            int r = class_9848.method_61327((int)pixel);
            if (!(a < 125 || ignoreWhite && r > 250 && g > 250 && b > 250)) {
                pixelArray[numUsedPixels] = new int[]{r, g, b};
                ++numUsedPixels;
                i += quality;
                continue;
            }
            ++i;
        }
        return (int[][])Arrays.copyOfRange(pixelArray, 0, numUsedPixels);
    }
}

