package mezz.jei.library.plugins.vanilla.anvil;

import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_310;
import net.minecraft.class_8059;
import net.minecraft.class_9697;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SmithingCategoryExtension<R extends class_8059> implements ISmithingCategoryExtension<R> {
	private final IPlatformRecipeHelper recipeHelper;

	public SmithingCategoryExtension(IPlatformRecipeHelper recipeHelper) {
		this.recipeHelper = recipeHelper;
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setTemplate(R recipe, T ingredientAcceptor) {
		recipeHelper.getTemplate(recipe)
			.ifPresent(ingredientAcceptor::add);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setBase(R recipe, T ingredientAcceptor) {
		class_1856 base = recipeHelper.getBase(recipe);
		ingredientAcceptor.add(base);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setAddition(R recipe, T ingredientAcceptor) {
		recipeHelper.getAddition(recipe)
			.ifPresent(ingredientAcceptor::add);
	}

	@Override
	public <T extends IIngredientAcceptor<T>> void setOutput(R recipe, T ingredientAcceptor) {
		Optional<class_1856> templateIngredient = recipeHelper.getTemplate(recipe);
		class_1856 baseIngredient = recipeHelper.getBase(recipe);
		Optional<class_1856> additionIngredient = recipeHelper.getAddition(recipe);

		class_310 minecraft = class_310.method_1551();
		class_10352 contextmap = class_10363.method_65008(Objects.requireNonNull(minecraft.field_1687));

		List<class_1799> templateStacks = templateIngredient.map(i -> i.method_64673().method_64738(contextmap)).orElse(List.of(class_1799.field_8037));
		if (templateStacks.isEmpty()) {
			templateStacks = List.of(class_1799.field_8037);
		}

		List<class_1799> baseStacks = baseIngredient.method_64673().method_64738(contextmap);
		if (baseStacks.isEmpty()) {
			baseStacks = List.of(class_1799.field_8037);
		}

		class_1799 addition = additionIngredient.map(i -> i.method_64673().method_64742(contextmap)).orElse(class_1799.field_8037);

		for (class_1799 template : templateStacks) {
			for (class_1799 base : baseStacks) {
				class_9697 recipeInput = new class_9697(template, base, addition);
				class_1799 output = RecipeUtil.assembleResultItem(recipeInput, recipe);
				ingredientAcceptor.add(output);
			}
		}
	}
}
