package mezz.jei.library.plugins.vanilla;

import com.mojang.serialization.Codec;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.ModIds;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.IExtendableCraftingRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.IExtendableSmithingRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModInfoRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.library.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTransformCategoryExtension;
import mezz.jei.library.plugins.vanilla.anvil.SmithingTrimCategoryExtension;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostableRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.BlastingCategory;
import mezz.jei.library.plugins.vanilla.cooking.CampfireCookingCategory;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceSmeltingCategory;
import mezz.jei.library.plugins.vanilla.cooking.SmokingCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.BlastingFuelCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.fuel.SmeltingFuelCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.SmokingFuelCategory;
import mezz.jei.library.plugins.vanilla.crafting.CraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShieldDecorationRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.TippedArrowRecipeMaker;
import mezz.jei.library.plugins.vanilla.grindstone.GrindstoneRecipeCategory;
import mezz.jei.library.plugins.vanilla.grindstone.GrindstoneRecipeMaker;
import mezz.jei.library.plugins.vanilla.gui.InventoryEffectRendererGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.RecipeBookGuiHandler;
import mezz.jei.library.plugins.vanilla.gui.ToastGuiHandler;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.EnchantedBookSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.LightSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.ingredients.subtypes.PotionSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.stonecutting.StoneCuttingRecipeCategory;
import mezz.jei.library.render.FluidTankRenderer;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.transfer.PlayerRecipeTransferHandler;
import net.minecraft.class_10289;
import net.minecraft.class_1706;
import net.minecraft.class_1708;
import net.minecraft.class_1714;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1845;
import net.minecraft.class_1872;
import net.minecraft.class_1876;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3802;
import net.minecraft.class_3858;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_3917;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_465;
import net.minecraft.class_471;
import net.minecraft.class_472;
import net.minecraft.class_479;
import net.minecraft.class_4862;
import net.minecraft.class_489;
import net.minecraft.class_4895;
import net.minecraft.class_490;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_8060;
import net.minecraft.class_8062;
import net.minecraft.class_8786;
import net.minecraft.class_8881;
import net.minecraft.class_8898;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

@JeiPlugin
public class VanillaPlugin implements IModPlugin {
	private static final Logger LOGGER = LogManager.getLogger();

	@Nullable
	private CraftingRecipeCategory craftingCategory;
	@Nullable
	private IRecipeCategory<class_8786<class_3975>> stonecuttingCategory;
	@Nullable
	private IRecipeCategory<class_8786<class_3861>> furnaceCategory;
	@Nullable
	private IRecipeCategory<class_8786<class_3862>> smokingCategory;
	@Nullable
	private IRecipeCategory<class_8786<class_3859>> blastingCategory;
	@Nullable
	private IRecipeCategory<class_8786<class_3920>> campfireCategory;
	@Nullable
	private SmithingRecipeCategory smithingCategory;

	@Override
	public class_2960 getPluginUid() {
		return class_2960.method_60655(ModIds.JEI_ID, "minecraft");
	}

	@Override
	public void registerItemSubtypes(ISubtypeRegistration registration) {
		registration.registerSubtypeInterpreter(class_1802.field_8087, PotionSubtypeInterpreter.INSTANCE);
		registration.registerSubtypeInterpreter(class_1802.field_8574, PotionSubtypeInterpreter.INSTANCE);
		registration.registerSubtypeInterpreter(class_1802.field_8436, PotionSubtypeInterpreter.INSTANCE);
		registration.registerSubtypeInterpreter(class_1802.field_8150, PotionSubtypeInterpreter.INSTANCE);
		registration.registerSubtypeInterpreter(class_1802.field_8598, EnchantedBookSubtypeInterpreter.INSTANCE);
		registration.registerSubtypeInterpreter(class_1802.field_30904, LightSubtypeInterpreter.INSTANCE);
		registration.registerFromDataComponentTypes(class_1802.field_8892, class_9334.field_56138);
		registration.registerFromDataComponentTypes(class_1802.field_39057, class_9334.field_49612);
		registration.registerFromDataComponentTypes(class_1802.field_8639, class_9334.field_49616);
		registration.registerFromDataComponentTypes(class_1802.field_8450, class_9334.field_49615);
		registration.registerFromDataComponentTypes(class_1802.field_8766, class_9334.field_49652);
		registration.registerFromDataComponentTypes(class_1802.field_50140, class_9334.field_50238);
		registration.registerFromDataComponentTypes(class_1802.field_8255, class_9334.field_49620, class_9334.field_49619);
		registration.registerFromDataComponentTypes(class_1802.field_42699, class_9334.field_49621);
	}

	@Override
	public void registerIngredients(IModIngredientRegistration registration) {
		ISubtypeManager subtypeManager = registration.getSubtypeManager();
		IColorHelper colorHelper = registration.getColorHelper();

		StackHelper stackHelper = new StackHelper(subtypeManager);
		ItemStackHelper itemStackHelper = new ItemStackHelper(stackHelper, colorHelper);
		List<class_1799> itemStacks = ItemStackListFactory.create(stackHelper, itemStackHelper);
		ItemStackRenderer itemStackRenderer = new ItemStackRenderer();
		registration.register(
			VanillaTypes.ITEM_STACK,
			itemStacks,
			itemStackHelper,
			itemStackRenderer,
			class_1799.field_51398
		);

		IPlatformFluidHelperInternal<?> platformFluidHelper = Services.PLATFORM.getFluidHelper();
		registerFluidIngredients(registration, platformFluidHelper);
	}

	@Override
	public void registerModInfo(IModInfoRegistration registration) {
		registration.addModAliases(ModIds.MINECRAFT_ID, "mc");
	}

	private <T> void registerFluidIngredients(IModIngredientRegistration registration, IPlatformFluidHelperInternal<T> platformFluidHelper) {
		ISubtypeManager subtypeManager = registration.getSubtypeManager();
		IColorHelper colorHelper = registration.getColorHelper();

		class_2378<class_3611> registry = RegistryUtil.getRegistry(class_7924.field_41270);
		List<T> fluidIngredients = FluidStackListFactory.create(registry, platformFluidHelper);
		FluidIngredientHelper<T> fluidIngredientHelper = new FluidIngredientHelper<>(subtypeManager, colorHelper, platformFluidHelper);
		FluidTankRenderer<T> fluidTankRenderer = new FluidTankRenderer<>(platformFluidHelper);
		IIngredientType<T> fluidIngredientType = platformFluidHelper.getFluidIngredientType();
		Codec<T> codec = platformFluidHelper.getCodec();
		registration.register(fluidIngredientType, fluidIngredients, fluidIngredientHelper, fluidTankRenderer, codec);
	}

	@Override
	public void registerCategories(IRecipeCategoryRegistration registration) {
		Textures textures = Internal.getTextures();
		IJeiHelpers jeiHelpers = registration.getJeiHelpers();
		IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
		registration.addRecipeCategories(
			craftingCategory = new CraftingRecipeCategory(guiHelper),
			stonecuttingCategory = new StoneCuttingRecipeCategory(guiHelper),
			furnaceCategory = new FurnaceSmeltingCategory(guiHelper),
			smokingCategory = new SmokingCategory(guiHelper),
			blastingCategory = new BlastingCategory(guiHelper),
			campfireCategory = new CampfireCookingCategory(guiHelper),
			smithingCategory = new SmithingRecipeCategory(guiHelper),
			new CompostableRecipeCategory(guiHelper),
			new SmeltingFuelCategory(guiHelper, textures),
			new SmokingFuelCategory(guiHelper, textures),
			new BlastingFuelCategory(guiHelper, textures),
			new BrewingRecipeCategory(guiHelper),
			new AnvilRecipeCategory(guiHelper),
			new GrindstoneRecipeCategory(guiHelper)
		);
	}

	@Override
	public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
		IExtendableCraftingRecipeCategory craftingCategory = registration.getCraftingCategory();
		craftingCategory.addExtension(class_3955.class, new CraftingCategoryExtension());

		IExtendableSmithingRecipeCategory smithingCategory = registration.getSmithingCategory();
		IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
		smithingCategory.addExtension(class_8060.class, new SmithingTransformCategoryExtension(recipeHelper));
		smithingCategory.addExtension(class_8062.class, new SmithingTrimCategoryExtension(recipeHelper));
	}

	@Override
	public void registerRecipes(IRecipeRegistration registration) {
		class_10289 clientSyncedRecipes = Internal.getClientSyncedRecipes();
		if (clientSyncedRecipes.method_64695().isEmpty()) {
			return;
		}

		ErrorUtil.checkNotNull(craftingCategory, "craftingCategory");
		ErrorUtil.checkNotNull(stonecuttingCategory, "stonecuttingCategory");
		ErrorUtil.checkNotNull(furnaceCategory, "furnaceCategory");
		ErrorUtil.checkNotNull(smokingCategory, "smokingCategory");
		ErrorUtil.checkNotNull(blastingCategory, "blastingCategory");
		ErrorUtil.checkNotNull(campfireCategory, "campfireCategory");
		ErrorUtil.checkNotNull(smithingCategory, "smithingCategory");

		IIngredientManager ingredientManager = registration.getIngredientManager();
		IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
		IJeiHelpers jeiHelpers = registration.getJeiHelpers();

		VanillaRecipes vanillaRecipes = new VanillaRecipes(clientSyncedRecipes);

		var craftingRecipes = vanillaRecipes.getCraftingRecipes(craftingCategory);
		var handledCraftingRecipes = craftingRecipes.getHandled();
		var unhandledCraftingRecipes = craftingRecipes.getUnhandled();
		var specialCraftingRecipes = replaceSpecialCraftingRecipes(unhandledCraftingRecipes, jeiHelpers);

		registration.addRecipes(RecipeTypes.CRAFTING, handledCraftingRecipes);
		registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);

		registration.addRecipes(RecipeTypes.STONECUTTING, vanillaRecipes.getStonecuttingRecipes(stonecuttingCategory));
		registration.addRecipes(RecipeTypes.SMELTING, vanillaRecipes.getFurnaceRecipes(furnaceCategory));
		registration.addRecipes(RecipeTypes.SMOKING, vanillaRecipes.getSmokingRecipes(smokingCategory));
		registration.addRecipes(RecipeTypes.BLASTING, vanillaRecipes.getBlastingRecipes(blastingCategory));
		registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, vanillaRecipes.getCampfireCookingRecipes(campfireCategory));
		registration.addRecipes(RecipeTypes.SMELTING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, class_3956.field_17546));
		registration.addRecipes(RecipeTypes.SMOKING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, class_3956.field_17548));
		registration.addRecipes(RecipeTypes.BLASTING_FUEL, FuelRecipeMaker.getFuelRecipes(ingredientManager, class_3956.field_17547));
		registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientManager));
		registration.addRecipes(RecipeTypes.SMITHING, vanillaRecipes.getSmithingRecipes(smithingCategory));
		registration.addRecipes(RecipeTypes.COMPOSTING, CompostingRecipeMaker.getRecipes(ingredientManager));

		class_310 minecraft = class_310.method_1551();
		class_638 level = minecraft.field_1687;
		ErrorUtil.checkNotNull(level, "minecraft.level");
		class_1845 potionBrewing = level.method_59547();
		IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
		List<IJeiBrewingRecipe> brewingRecipes = recipeHelper.getBrewingRecipes(ingredientManager, vanillaRecipeFactory, potionBrewing);
		brewingRecipes.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
		registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
		registration.addRecipes(RecipeTypes.GRINDSTONE, GrindstoneRecipeMaker.getGrindstoneRecipes(ingredientManager, recipeHelper));
	}

	@Override
	public void registerGuiHandlers(IGuiHandlerRegistration registration) {
		registration.addRecipeClickArea(class_479.class, 88, 32, 28, 23, RecipeTypes.CRAFTING);
		registration.addRecipeClickArea(class_8898.class, 88, 32, 28, 23, RecipeTypes.CRAFTING);
		registration.addRecipeClickArea(class_490.class, 137, 29, 10, 13, RecipeTypes.CRAFTING);
		registration.addRecipeClickArea(class_472.class, 97, 16, 14, 30, RecipeTypes.BREWING);
		registration.addRecipeClickArea(class_3873.class, 78, 32, 28, 23, RecipeTypes.SMELTING, RecipeTypes.SMELTING_FUEL);
		registration.addRecipeClickArea(class_3874.class, 78, 32, 28, 23, RecipeTypes.SMOKING, RecipeTypes.SMOKING_FUEL);
		registration.addRecipeClickArea(class_3871.class, 78, 32, 28, 23, RecipeTypes.BLASTING, RecipeTypes.BLASTING_FUEL);
		registration.addRecipeClickArea(class_471.class, 102, 48, 22, 15, RecipeTypes.ANVIL);
		registration.addRecipeClickArea(class_3802.class, 92, 31, 28, 21, RecipeTypes.GRINDSTONE);
		registration.addRecipeClickArea(class_4895.class, 68, 49, 22, 15, RecipeTypes.SMITHING);

		registration.addGenericGuiContainerHandler(class_465.class, new InventoryEffectRendererGuiHandler());
		registration.addGuiContainerHandler(class_479.class, new RecipeBookGuiHandler<>());
		registration.addGuiContainerHandler(class_490.class, new RecipeBookGuiHandler<>());
		registration.addGenericGuiContainerHandler(class_489.class, new RecipeBookGuiHandler<>());
		registration.addGlobalGuiHandler(new ToastGuiHandler());
	}

	@Override
	public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
		registration.addRecipeTransferHandler(class_1714.class, class_3917.field_17333, RecipeTypes.CRAFTING, 1, 9, 10, 36);
		registration.addRecipeTransferHandler(class_8881.class, class_3917.field_46790, RecipeTypes.CRAFTING, 0, 9, 9, 36);
		registration.addRecipeTransferHandler(class_3858.class, class_3917.field_17335, RecipeTypes.SMELTING, 0, 1, 3, 36);
		registration.addRecipeTransferHandler(class_3858.class, class_3917.field_17335, RecipeTypes.SMELTING_FUEL, 1, 1, 3, 36);
		registration.addRecipeTransferHandler(class_3706.class, class_3917.field_17342, RecipeTypes.SMOKING, 0, 1, 3, 36);
		registration.addRecipeTransferHandler(class_3706.class, class_3917.field_17342, RecipeTypes.SMOKING_FUEL, 1, 1, 3, 36);
		registration.addRecipeTransferHandler(class_3705.class, class_3917.field_17331, RecipeTypes.BLASTING, 0, 1, 3, 36);
		registration.addRecipeTransferHandler(class_3705.class, class_3917.field_17331, RecipeTypes.BLASTING_FUEL, 1, 1, 3, 36);
		registration.addRecipeTransferHandler(class_1708.class, class_3917.field_17332, RecipeTypes.BREWING, 0, 4, 5, 36);
		registration.addRecipeTransferHandler(class_1706.class, class_3917.field_17329, RecipeTypes.ANVIL, 0, 2, 3, 36);
		registration.addRecipeTransferHandler(class_4862.class, class_3917.field_22484, RecipeTypes.SMITHING, 0, 3, 3, 36);

		IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
		PlayerRecipeTransferHandler recipeTransferHandler = new PlayerRecipeTransferHandler(transferHelper);
		registration.addRecipeTransferHandler(recipeTransferHandler, RecipeTypes.CRAFTING);
	}

	@Override
	public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
		registration.addCraftingStation(RecipeTypes.CRAFTING,
			class_2246.field_9980,
			class_2246.field_46797
		);
		registration.addCraftingStation(RecipeTypes.CAMPFIRE_COOKING,
			class_2246.field_17350,
			class_2246.field_23860
		);
		registration.addCraftingStation(RecipeTypes.STONECUTTING, class_2246.field_16335);
		registration.addCraftingStation(RecipeTypes.SMELTING, class_2246.field_10181);
		registration.addCraftingStation(RecipeTypes.SMOKING, class_2246.field_16334);
		registration.addCraftingStation(RecipeTypes.BLASTING, class_2246.field_16333);
		registration.addCraftingStation(RecipeTypes.SMELTING_FUEL, class_2246.field_10181);
		registration.addCraftingStation(RecipeTypes.SMOKING_FUEL, class_2246.field_16334);
		registration.addCraftingStation(RecipeTypes.BLASTING_FUEL, class_2246.field_16333);
		registration.addCraftingStation(RecipeTypes.BREWING, class_2246.field_10333);
		registration.addCraftingStation(RecipeTypes.ANVIL, class_2246.field_10535);
		registration.addCraftingStation(RecipeTypes.GRINDSTONE, class_2246.field_16337);
		registration.addCraftingStation(RecipeTypes.SMITHING, class_2246.field_16329);
		registration.addCraftingStation(RecipeTypes.COMPOSTING, class_2246.field_17563);
	}

	public Optional<CraftingRecipeCategory> getCraftingCategory() {
		return Optional.ofNullable(craftingCategory);
	}

	public Optional<SmithingRecipeCategory> getSmithingCategory() {
		return Optional.ofNullable(smithingCategory);
	}

	/**
	 * By default, JEI can't handle special recipes.
	 * This method expands some special unhandled recipes into a list of normal recipes that JEI can understand.
	 * <p>
	 * If a special recipe we know how to replace is not present (because it has been removed),
	 * we do not replace it.
	 */
	private static List<class_8786<class_3955>> replaceSpecialCraftingRecipes(List<class_8786<class_3955>> unhandledCraftingRecipes, IJeiHelpers jeiHelpers) {
		Map<Class<? extends class_3955>, Supplier<List<class_8786<class_3955>>>> replacers = new IdentityHashMap<>();
		replacers.put(class_1876.class, () -> TippedArrowRecipeMaker.createRecipes(jeiHelpers));
		replacers.put(class_1872.class, ShieldDecorationRecipeMaker::createRecipes);

		return unhandledCraftingRecipes.stream()
			.map(class_8786::comp_1933)
			.map(class_3955::getClass)
			.filter(replacers::containsKey)
			.distinct()
			// distinct + this limit will ensure we stop iterating early if we find all the recipes we're looking for.
			.limit(replacers.size())
			.flatMap(recipeClass -> {
				var supplier = replacers.get(recipeClass);
				try {
					return supplier.get()
						.stream();
				} catch (RuntimeException e) {
					LOGGER.error("Failed to create JEI recipes for {}", recipeClass, e);
					return Stream.of();
				}
			})
			.toList();
	}
}
