package mezz.jei.library.plugins.debug;

import mezz.jei.api.constants.ModIds;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_5321;
import net.minecraft.class_7710;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import java.util.List;

public class DebugSimpleRecipeManagerPlugin implements ISimpleRecipeManagerPlugin<class_8786<class_3955>> {
	private final IVanillaRecipeFactory vanillaRecipeFactory;

	public DebugSimpleRecipeManagerPlugin(IJeiHelpers jeiHelpers) {
		this.vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();
	}

	@Override
	public boolean isHandledInput(ITypedIngredient<?> input) {
		class_1799 itemStack = input.getItemStack().orElse(class_1799.field_8037);
		return itemStack.method_31574(class_1802.field_30904);
	}

	@Override
	public boolean isHandledOutput(ITypedIngredient<?> output) {
		class_1799 itemStack = output.getItemStack().orElse(class_1799.field_8037);
		return itemStack.method_31574(class_1802.field_8459);
	}

	@Override
	public List<class_8786<class_3955>> getRecipesForInput(ITypedIngredient<?> input) {
		return List.of(generateRecipe());
	}

	@Override
	public List<class_8786<class_3955>> getRecipesForOutput(ITypedIngredient<?> output) {
		return List.of(generateRecipe());
	}

	@Override
	public List<class_8786<class_3955>> getAllRecipes() {
		return List.of(generateRecipe());
	}

	private class_8786<class_3955> generateRecipe() {
		class_3955 recipe = vanillaRecipeFactory.createShapedRecipeBuilder(class_7710.field_40251, new class_10302.class_10306(class_1802.field_8459))
			.pattern("lll")
			.pattern("lll")
			.pattern("lll")
			.define('l', class_1856.method_8101(class_1802.field_30904))
			.build();
		class_2960 resourceLocation = class_2960.method_60655(ModIds.JEI_ID, "debug_simple_recipe");
		class_5321<class_1860<?>> resourceKey = class_5321.method_29179(class_7924.field_52178, resourceLocation);
		return new class_8786<>(resourceKey, recipe);
	}
}
