package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public record RecipeLayoutWithButtons<R>(
	IRecipeLayoutDrawable<R> recipeLayout,
	RecipeTransferButton transferButton,
	RecipeBookmarkButton bookmarkButton
) {
	public int totalWidth() {
		class_768 area = recipeLayout.getRect();
		class_768 areaWithBorder = recipeLayout.getRectWithBorder();
		int leftBorderWidth = area.method_3321() - areaWithBorder.method_3321();
		int rightAreaWidth = areaWithBorder.method_3319() - leftBorderWidth;

		if (transferButton.isVisible()) {
			class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
			int buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
			rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
		}

		if (bookmarkButton.isVisible()) {
			class_768 buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
			int buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
			rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
		}

		return leftBorderWidth + rightAreaWidth;
	}

	public IUserInputHandler createUserInputHandler() {
		return new CombinedInputHandler(
			"RecipeLayoutWithButtons",
			bookmarkButton.createInputHandler(),
			transferButton.createInputHandler(),
			new RecipeLayoutUserInputHandler<>(recipeLayout)
		);
	}

	public void tick(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
		recipeLayout.tick();
		transferButton.update(parentContainer, player);
		bookmarkButton.tick();
	}

	private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler {

		@Override
		public Optional<IUserInputHandler> handleUserInput(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
			final double mouseX = input.getMouseX();
			final double mouseY = input.getMouseY();
			if (recipeLayout.isMouseOver(mouseX, mouseY)) {
				class_3675.class_306 key = input.getKey();
				boolean simulate = input.isSimulate();

				if (recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
					return Optional.of(this);
				}

				IInternalKeyMappings keyMappings = Internal.getKeyMappings();
				if (keyMappings.getCopyRecipeId().isActiveAndMatches(key)) {
					if (handleCopyRecipeId(recipeLayout, simulate)) {
						return Optional.of(this);
					}
				}
			}
			return Optional.empty();
		}

		private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout, boolean simulate) {
			if (simulate) {
				return true;
			}
			class_310 minecraft = class_310.method_1551();
			class_746 player = minecraft.field_1724;
			IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
			R recipe = recipeLayout.getRecipe();
			class_2960 registryName = recipeCategory.getRegistryName(recipe);
			if (registryName == null) {
				class_5250 message = class_2561.method_43471("jei.message.copy.recipe.id.failure");
				if (player != null) {
					player.method_7353(message, false);
				}
				return false;
			}

			String recipeId = registryName.toString();
			minecraft.field_1774.method_1455(recipeId);
			class_5250 message = class_2561.method_43469("jei.message.copy.recipe.id.success", class_2561.method_43470(recipeId));
			if (player != null) {
				player.method_7353(message, false);
			}
			return true;
		}

		@Override
		public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
			if (recipeLayout.isMouseOver(mouseX, mouseY) &&
				recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY)
			) {
				return Optional.of(this);
			}

			return Optional.empty();
		}
	}
}
