package mezz.jei.gui.input;

import mezz.jei.common.Internal;
import mezz.jei.common.gui.elements.ScalableDrawable;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.core.util.TextHistory;
import mezz.jei.gui.input.focus.ScreenFocusHandler;
import mezz.jei.gui.input.handlers.TextFieldInputHandler;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.BooleanSupplier;

public class GuiTextFieldFilter extends class_342 {
	private static final int maxSearchLength = 128;
	private static final TextHistory history = new TextHistory();
	private final BooleanSupplier filterEmpty;

	private ImmutableRect2i area;
	private final ScalableDrawable background;
	private ImmutableRect2i backgroundBounds;

	private @Nullable ScreenFocusHandler screenUnfocusHandler;

	public GuiTextFieldFilter(BooleanSupplier filterEmpty) {
		// TODO narrator string
		super(class_310.method_1551().field_1772, 0, 0, 0, 0, class_5244.field_39003);
		this.filterEmpty = filterEmpty;

		method_1880(maxSearchLength);
		this.area = ImmutableRect2i.EMPTY;
		Textures textures = Internal.getTextures();
		this.background = textures.getSearchBackground();
		this.backgroundBounds = ImmutableRect2i.EMPTY;
		method_1858(false);
	}

	public void updateBounds(ImmutableRect2i area) {
		this.backgroundBounds = area;
		method_46421(area.getX() + 4);
		method_46419(area.getY() + (area.getHeight() - 8) / 2);
		this.field_22758 = area.getWidth() - 12;
		this.field_22759 = area.getHeight();
		this.area = area;
	}

	@Override
	public void method_1852(String filterText) {
		if (!filterText.equals(method_1882())) {
			super.method_1852(filterText);
		}
		int color = filterEmpty.getAsBoolean() ? 0xFFFF0000 : 0xFFFFFFFF;
		method_1868(color);
	}

	public Optional<String> getHistory(TextHistory.Direction direction) {
		String currentText = method_1882();
		return history.get(direction, currentText);
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		return area.contains(mouseX, mouseY);
	}

	public IUserInputHandler createInputHandler() {
		return new TextFieldInputHandler(this);
	}

	@Override
	public void method_25365(boolean keyboardFocus) {
		final boolean previousFocus = method_25370();
		super.method_25365(keyboardFocus);

		if (previousFocus != keyboardFocus) {
			class_310 minecraft = class_310.method_1551();
			if (keyboardFocus) {
				class_437 screen = minecraft.field_1755;
				if (screen != null) {
					screenUnfocusHandler = ScreenFocusHandler.create(screen);
					if (screenUnfocusHandler != null) {
						screenUnfocusHandler.unFocus();
					}
				}
			} else {
				if (screenUnfocusHandler != null) {
					screenUnfocusHandler.focus();
					screenUnfocusHandler = null;
				}
			}

			String text = method_1882();
			history.add(text);
		}
	}

	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		if (this.method_1885()) {
			background.draw(guiGraphics, this.backgroundBounds);
		}
		super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
	}
}
