/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.core.collect.SetMultiMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_6880;

public class BrewingRecipeUtil {
    public static final class_1799 POTION = new class_1799((class_1935)class_1802.field_8574);
    public static final class_1799 WATER_BOTTLE = class_1844.method_57400((class_1792)POTION.method_7909(), (class_6880)class_1847.field_8991);
    private final Map<Object, Integer> brewingStepCache = new HashMap<Object, Integer>();
    private final SetMultiMap<Object, Object> potionMap = new SetMultiMap();
    private final IIngredientHelper<class_1799> itemStackHelper;

    public BrewingRecipeUtil(IIngredientHelper<class_1799> itemStackHelper) {
        this.itemStackHelper = itemStackHelper;
        this.clearCache();
    }

    public void addRecipe(List<class_1799> inputPotions, class_1799 outputPotion) {
        Object potionOutputUid = this.itemStackHelper.getUid(outputPotion, UidContext.Recipe);
        for (class_1799 inputPotion : inputPotions) {
            Object potionInputUid = this.itemStackHelper.getUid(inputPotion, UidContext.Recipe);
            this.potionMap.put(potionOutputUid, potionInputUid);
        }
        this.clearCache();
    }

    public int getBrewingSteps(class_1799 outputPotion) {
        Object potionInputUid = this.itemStackHelper.getUid(outputPotion, UidContext.Recipe);
        return this.getBrewingSteps(potionInputUid, new HashSet<Object>());
    }

    private void clearCache() {
        if (this.brewingStepCache.size() != 1) {
            this.brewingStepCache.clear();
            Object waterBottleUid = this.itemStackHelper.getUid(WATER_BOTTLE, UidContext.Recipe);
            this.brewingStepCache.put(waterBottleUid, 0);
        }
    }

    private int getBrewingSteps(Object potionOutputUid, Set<Object> previousSteps) {
        Integer cachedBrewingSteps = this.brewingStepCache.get(potionOutputUid);
        if (cachedBrewingSteps != null) {
            return cachedBrewingSteps;
        }
        if (!previousSteps.add(potionOutputUid)) {
            return Integer.MAX_VALUE;
        }
        Collection prevPotionUids = this.potionMap.get(potionOutputUid);
        int minPrevSteps = prevPotionUids.stream().mapToInt(prevPotion -> this.getBrewingSteps(prevPotion, previousSteps)).min().orElse(Integer.MAX_VALUE);
        int brewingSteps = minPrevSteps == Integer.MAX_VALUE ? Integer.MAX_VALUE : minPrevSteps + 1;
        this.brewingStepCache.put(potionOutputUid, brewingSteps);
        return brewingSteps;
    }
}

