/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.runtime.IRecipesGui;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.SameElementInputHandler;
import net.minecraft.class_437;
import net.minecraft.class_465;

public class GuiAreaInputHandler
implements IUserInputHandler {
    private final IFocusFactory focusFactory;
    private final IScreenHelper screenHelper;
    private final IRecipesGui recipesGui;

    public GuiAreaInputHandler(IScreenHelper screenHelper, IRecipesGui recipesGui, IFocusFactory focusFactory) {
        this.focusFactory = focusFactory;
        this.screenHelper = screenHelper;
        this.recipesGui = recipesGui;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, IGuiProperties guiProperties, UserInput input, IInternalKeyMappings keyBindings) {
        if (input.is(keyBindings.getLeftClick()) && screen instanceof class_465) {
            class_465 guiContainer = (class_465)screen;
            int guiLeft = guiProperties.guiLeft();
            int guiTop = guiProperties.guiTop();
            double guiMouseX = input.getMouseX() - (double)guiLeft;
            double guiMouseY = input.getMouseY() - (double)guiTop;
            return this.screenHelper.getGuiClickableArea(guiContainer, guiMouseX, guiMouseY).findFirst().map(clickableArea -> {
                if (!input.isSimulate()) {
                    clickableArea.onClick(this.focusFactory, this.recipesGui);
                }
                ImmutableRect2i screenArea = new ImmutableRect2i(clickableArea.getArea()).addOffset(guiLeft, guiTop);
                return new SameElementInputHandler(this, screenArea::contains);
            });
        }
        return Optional.empty();
    }
}

