package mezz.jei.library.plugins.vanilla.grindstone;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import mezz.jei.api.recipe.vanilla.IJeiGrindstoneRecipe;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.class_10630;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3803;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class GrindstoneRecipeMaker {
	private static class_3803 GRINDSTONE_MENU;
	private static final int TOP_SLOT = 0;
	private static final int BOTTOM_SLOT = 1;
	private static final int OUTPUT_SLOT = 2;
	public static List<IJeiGrindstoneRecipe> getGrindstoneRecipes(IIngredientManager ingredientManager, IPlatformRecipeHelper platformHelper) {
		return Stream.concat(
						getRepairRecipes(ingredientManager),
						getDisenchantRecipes(ingredientManager, platformHelper)
				)
				.toList();
	}
	private static Stream<IJeiGrindstoneRecipe> getDisenchantRecipes(
			IIngredientManager ingredientManager,
			IPlatformRecipeHelper platformHelper
	) {
		class_2378<class_1887> registry = RegistryUtil.getRegistry(class_7924.field_41265);
		List<class_6880.class_6883<class_1887>> enchantments = registry.method_42017().toList();
		List<IJeiGrindstoneRecipe> grindstoneRecipes = new ArrayList<>();
		for (class_1799 stack : ingredientManager.getAllItemStacks()) {
			if (!stack.method_7923()) {
				continue;
			}
			for (class_6880.class_6883<class_1887> enchantmentHolder : enchantments) {
				if (enchantmentHolder.method_40220(class_9636.field_51551)) {
					continue;
				}
				class_1887 enchantment = enchantmentHolder.comp_349();
				if (!enchantment.method_60046(stack) ||
					!platformHelper.isItemEnchantable(stack, enchantmentHolder)
				) {
					continue;
				}
				Optional<class_5321<class_1887>> enchantmentResourceLocation = registry.method_29113(enchantment);
				String enchantmentPath = enchantmentResourceLocation.map(enchantmentResourceKey -> enchantmentResourceKey.method_29177().method_12832()).orElse(null);
				for (int level = 1; level <= Math.min(enchantment.method_8183(), 10); level++) {
					class_1799 enchantedStack = stack.method_7972();
					enchantedStack.method_7978(enchantmentHolder, level);
					String itemId = stack.method_7909().method_7876();
					class_2960 uid = enchantmentPath != null ? class_2960.method_60656("grindstone.disenchantment.%s.%s.%d".formatted(itemId, enchantmentPath, level)) : null;
					IJeiGrindstoneRecipe grindstoneRecipe = getGrindstoneRecipe(enchantedStack, class_1799.field_8037, uid);
					if (grindstoneRecipe != null) {
						grindstoneRecipes.add(grindstoneRecipe);
					}
				}
			}
		}

		return grindstoneRecipes.stream();
	}


	private static Stream<IJeiGrindstoneRecipe> getRepairRecipes(IIngredientManager ingredientManager) {
		return ingredientManager.getAllItemStacks()
			.stream()
			.filter(class_1799::method_7963)
			.map(stack -> {
				stack.method_7974(stack.method_7936() * 3 / 4);
				class_1799 topInput = stack.method_7972();
				class_1799 bottomInput = stack.method_7972();
				String itemId = stack.method_7909().method_7876();
				return getGrindstoneRecipe(topInput, bottomInput, class_2960.method_60656("grindstone.self_repair." + itemId));
			})
			.filter(Objects::nonNull);
	}

	@SuppressWarnings("SequencedCollectionMethodCanBeUsed")
	@Nullable
	private static IJeiGrindstoneRecipe getGrindstoneRecipe(class_1799 topInput, class_1799 bottomInput, @Nullable class_2960 uid) {
		class_3803 grindstoneMenu = getFakeGrindstoneMenu();
		if (grindstoneMenu == null) {
			return null;
		}
		grindstoneMenu.field_7761.get(TOP_SLOT).method_7673(topInput);
		grindstoneMenu.field_7761.get(BOTTOM_SLOT).method_7673(topInput);
		class_1799 output = grindstoneMenu.field_7761.get(OUTPUT_SLOT).method_7677();
		if (output.method_7960()) {
			return null;
		}
		int minXp = getMinXp(grindstoneMenu);
		int maxXp = minXp * 2;
		return new GrindstoneRecipe(List.of(topInput), List.of(bottomInput), List.of(output), minXp, maxXp, uid);
	}

	@SuppressWarnings("SequencedCollectionMethodCanBeUsed")
	private static int getMinXp(class_3803 grindstoneMenu) {
		class_1799 topItem = grindstoneMenu.field_7761.get(TOP_SLOT).method_7677();
		class_1799 bottomItem = grindstoneMenu.field_7761.get(BOTTOM_SLOT).method_7677();
		int topXp = getExperienceFromItem(topItem);
		int bottomXp = getExperienceFromItem(bottomItem);
		return MathUtil.divideCeil(topXp + bottomXp, 2);
	}

	private static int getExperienceFromItem(class_1799 stack) {
		int i = 0;
		class_9304 itemEnchantments = class_1890.method_57532(stack);

		for (Object2IntMap.Entry<class_6880<class_1887>> entry : itemEnchantments.method_57539()) {
			class_6880<class_1887> holder = entry.getKey();
			int j = entry.getIntValue();
			if (!holder.method_40220(class_9636.field_51551)) {
				i += holder.comp_349().method_8182(j);
			}
		}

		return i;
	}

	@Nullable
	private static class_3803 getFakeGrindstoneMenu() {
		if (GRINDSTONE_MENU == null) {
			class_1657 player = class_310.method_1551().field_1724;
			if (player == null) {
				return null;
			}
			class_1661 fakeInventory = new class_1661(player, new class_10630());
			GRINDSTONE_MENU = new class_3803(0, fakeInventory);
			return GRINDSTONE_MENU;
		}
		return GRINDSTONE_MENU;
	}
}
