package mezz.jei.library.recipes;

import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_3955;
import java.util.function.Supplier;

public class RecipeSerializers {
	private static @Nullable RecipeSerializers INSTANCE;

	private final Supplier<class_1865<? extends class_3955>> jeiShapedRecipeSerializer;

	public static void register(Supplier<class_1865<? extends class_3955>> jeiShapedRecipeSerializer) {
		INSTANCE = new RecipeSerializers(jeiShapedRecipeSerializer);
	}

	private RecipeSerializers(Supplier<class_1865<? extends class_3955>> jeiShapedRecipeSerializer) {
		this.jeiShapedRecipeSerializer = jeiShapedRecipeSerializer;
	}

	public static class_1865<? extends class_3955> getJeiShapedRecipeSerializer() {
		if (INSTANCE == null) {
			throw new IllegalStateException("Recipe serializer not yet initialized");
		}
		return INSTANCE.jeiShapedRecipeSerializer.get();
	}
}
