/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.ingredients.IIngredientSupplier;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.codecs.TypedIngredientCodecs;
import mezz.jei.core.util.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.jetbrains.annotations.Nullable;

public class CodecHelper
implements ICodecHelper {
    private static final Codec<RecipeHolder<?>> RECIPE_HOLDER_CODEC = Codec.lazyInitialized(() -> ResourceLocation.CODEC.flatXmap(resourceLocation -> {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        assert (level != null);
        RecipeManager recipeManager = level.getRecipeManager();
        return recipeManager.byKey(resourceLocation).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Could not find recipe for key: " + String.valueOf(resourceLocation)));
    }, recipeHolder -> DataResult.success((Object)recipeHolder.id())));
    private final IIngredientManager ingredientManager;
    private final IFocusFactory focusFactory;
    private final Map<RecipeType<?>, Codec<?>> defaultRecipeCodecs = new HashMap();
    @Nullable
    private Codec<RecipeType<?>> recipeTypeCodec;

    public CodecHelper(IIngredientManager ingredientManager, IFocusFactory focusFactory) {
        this.ingredientManager = ingredientManager;
        this.focusFactory = focusFactory;
    }

    @Override
    public Codec<IIngredientType<?>> getIngredientTypeCodec() {
        return TypedIngredientCodecs.getIngredientTypeCodec(this.ingredientManager);
    }

    @Override
    public MapCodec<ITypedIngredient<?>> getTypedIngredientCodec() {
        return TypedIngredientCodecs.getIngredientCodec(this.ingredientManager);
    }

    @Override
    public <T> Codec<ITypedIngredient<T>> getTypedIngredientCodec(IIngredientType<T> ingredientType) {
        return TypedIngredientCodecs.getIngredientCodec(ingredientType, this.ingredientManager);
    }

    @Override
    public <T extends RecipeHolder<?>> Codec<T> getRecipeHolderCodec() {
        Codec<RecipeHolder<?>> recipeHolderCodec = RECIPE_HOLDER_CODEC;
        return recipeHolderCodec;
    }

    @Override
    public <T> Codec<T> getSlowRecipeCategoryCodec(IRecipeCategory<T> recipeCategory, IRecipeManager recipeManager) {
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        Object codec = this.defaultRecipeCodecs.get(recipeType);
        if (codec == null) {
            codec = this.createDefaultRecipeCategoryCodec(recipeManager, recipeCategory);
            this.defaultRecipeCodecs.put(recipeType, (Codec<?>)codec);
        }
        return codec;
    }

    private <T> Codec<T> createDefaultRecipeCategoryCodec(IRecipeManager recipeManager, IRecipeCategory<T> recipeCategory) {
        return RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("resourceLocation").forGetter(Pair::first), (App)this.getTypedIngredientCodec().codec().fieldOf("output").forGetter(Pair::second)).apply((Applicative)builder, Pair::new)).flatXmap(pair -> {
            ResourceLocation registryName = (ResourceLocation)pair.first();
            ITypedIngredient output = (ITypedIngredient)pair.second();
            IFocus focus = this.focusFactory.createFocus(RecipeIngredientRole.OUTPUT, output);
            RecipeType recipeType = recipeCategory.getRecipeType();
            return recipeManager.createRecipeLookup(recipeType).limitFocus(List.of(focus)).get().filter(recipe -> registryName.equals((Object)recipeCategory.getRegistryName(recipe))).findFirst().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "No recipe found for registry name: " + String.valueOf(registryName)));
        }, recipe -> {
            ResourceLocation registryName = recipeCategory.getRegistryName(recipe);
            if (registryName == null) {
                return DataResult.error(() -> "No registry name for recipe");
            }
            IIngredientSupplier ingredients = recipeManager.getRecipeIngredients(recipeCategory, recipe);
            List<ITypedIngredient<?>> outputs = ingredients.getIngredients(RecipeIngredientRole.OUTPUT);
            if (outputs.isEmpty()) {
                return DataResult.error(() -> "No outputs for recipe");
            }
            Pair result = new Pair(registryName, outputs.getFirst());
            return DataResult.success(result);
        });
    }

    @Override
    public Codec<RecipeType<?>> getRecipeTypeCodec(IRecipeManager recipeManager) {
        if (this.recipeTypeCodec == null) {
            this.recipeTypeCodec = ResourceLocation.CODEC.flatXmap(resourceLocation -> recipeManager.getRecipeType((ResourceLocation)resourceLocation).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Failed to find recipe type " + String.valueOf(resourceLocation))), recipeType -> {
                ResourceLocation uid = recipeType.getUid();
                return DataResult.success((Object)uid);
            });
        }
        return this.recipeTypeCodec;
    }
}

