/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.gui.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.util.ImmutablePoint2i;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.library.gui.ingredients.CycleTicker;
import mezz.jei.library.gui.recipes.RecipeLayoutInputHandler;
import mezz.jei.library.gui.recipes.ShapelessIcon;
import mezz.jei.library.gui.recipes.layout.builder.RecipeLayoutBuilder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.renderer.Rect2i;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RecipeLayout<R>
implements IRecipeLayoutDrawable<R> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_RECIPE_BORDER_PADDING = 4;
    public static final int RECIPE_BUTTON_SIZE = 13;
    public static final int RECIPE_BUTTON_SPACING = 2;
    private final IRecipeCategory<R> recipeCategory;
    private final Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators;
    private final List<IRecipeSlotDrawable> recipeCategorySlots;
    private final List<IRecipeSlotDrawable> allSlots;
    private final List<ISlottedRecipeWidget> slottedWidgets;
    private final CycleTicker cycleTicker;
    private final IFocusGroup focuses;
    private final List<IRecipeWidget> allWidgets;
    private final R recipe;
    private final IScalableDrawable recipeBackground;
    private final int recipeBorderPadding;
    private final ImmutableRect2i recipeTransferButtonArea;
    @Nullable
    private final ShapelessIcon shapelessIcon;
    private final RecipeLayoutInputHandler<R> inputHandler;
    private ImmutableRect2i area;

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager) {
        DrawableNineSliceTexture recipeBackground = Internal.getTextures().getRecipeBackground();
        return RecipeLayout.create(recipeCategory, decorators, recipe, focuses, ingredientManager, recipeBackground, 4);
    }

    public static <T> Optional<IRecipeLayoutDrawable<T>> create(IRecipeCategory<T> recipeCategory, Collection<IRecipeCategoryDecorator<T>> decorators, T recipe, IFocusGroup focuses, IIngredientManager ingredientManager, IScalableDrawable recipeBackground, int recipeBorderPadding) {
        RecipeLayoutBuilder<T> builder = new RecipeLayoutBuilder<T>(recipeCategory, recipe, ingredientManager);
        try {
            recipeCategory.setRecipe(builder, recipe, focuses);
            recipeCategory.createRecipeExtras(builder, recipe, focuses);
            RecipeLayout<T> recipeLayout = builder.buildRecipeLayout(focuses, decorators, recipeBackground, recipeBorderPadding);
            return Optional.of(recipeLayout);
        }
        catch (LinkageError | RuntimeException e) {
            LOGGER.error("Error caught from Recipe Category: {}", (Object)recipeCategory.getRecipeType().getUid(), (Object)e);
            return Optional.empty();
        }
    }

    public RecipeLayout(IRecipeCategory<R> recipeCategory, Collection<IRecipeCategoryDecorator<R>> recipeCategoryDecorators, R recipe, IScalableDrawable recipeBackground, int recipeBorderPadding, @Nullable ShapelessIcon shapelessIcon, ImmutablePoint2i recipeTransferButtonPos, List<IRecipeSlotDrawable> recipeCategorySlots, List<IRecipeSlotDrawable> allSlots, List<ISlottedRecipeWidget> slottedWidgets, List<IRecipeWidget> widgets, List<IJeiInputHandler> inputHandlers, List<IJeiGuiEventListener> guiEventListeners, CycleTicker cycleTicker, IFocusGroup focuses) {
        this.recipeCategory = recipeCategory;
        this.recipeCategoryDecorators = recipeCategoryDecorators;
        this.slottedWidgets = Collections.unmodifiableList(slottedWidgets);
        this.cycleTicker = cycleTicker;
        this.focuses = focuses;
        this.inputHandler = new RecipeLayoutInputHandler(this, inputHandlers, guiEventListeners);
        HashSet<IRecipeWidget> allWidgets = new HashSet<IRecipeWidget>(widgets);
        allWidgets.addAll(slottedWidgets);
        this.allWidgets = List.copyOf(allWidgets);
        this.recipeCategorySlots = recipeCategorySlots;
        this.allSlots = Collections.unmodifiableList(allSlots);
        this.recipeBorderPadding = recipeBorderPadding;
        this.area = new ImmutableRect2i(0, 0, recipeCategory.getWidth(), recipeCategory.getHeight());
        this.recipeTransferButtonArea = new ImmutableRect2i(recipeTransferButtonPos.x(), recipeTransferButtonPos.y(), 13, 13);
        this.recipe = recipe;
        this.recipeBackground = recipeBackground;
        this.shapelessIcon = shapelessIcon;
        recipeCategory.onDisplayedIngredientsUpdate(recipe, recipeCategorySlots, focuses);
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    @Override
    public void drawRecipe(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IDrawable background = this.recipeCategory.getBackground();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.recipeBackground.draw(guiGraphics, this.getRectWithBorder());
        double recipeMouseX = mouseX - this.area.getX();
        double recipeMouseY = mouseY - this.area.getY();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.area.getX(), (float)this.area.getY(), 0.0f);
        background.draw(guiGraphics);
        poseStack.pushPose();
        for (IRecipeSlotDrawable iRecipeSlotDrawable : this.recipeCategorySlots) {
            iRecipeSlotDrawable.draw(guiGraphics);
        }
        this.recipeCategory.draw(this.recipe, recipeCategorySlotsView, guiGraphics, recipeMouseX, recipeMouseY);
        for (IRecipeWidget iRecipeWidget : this.allWidgets) {
            ScreenPosition position = iRecipeWidget.getPosition();
            poseStack.pushPose();
            poseStack.translate((float)position.x(), (float)position.y(), 0.0f);
            iRecipeWidget.draw(guiGraphics, recipeMouseX, recipeMouseY);
            poseStack.popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        for (IRecipeCategoryDecorator iRecipeCategoryDecorator : this.recipeCategoryDecorators) {
            poseStack.pushPose();
            iRecipeCategoryDecorator.draw(this.recipe, this.recipeCategory, recipeCategorySlotsView, guiGraphics, recipeMouseX, recipeMouseY);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
        if (this.shapelessIcon != null) {
            this.shapelessIcon.draw(guiGraphics);
        }
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    @Override
    public void drawOverlays(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int recipeMouseX = mouseX - this.area.getX();
        int recipeMouseY = mouseY - this.area.getY();
        RenderSystem.disableBlend();
        IRecipeSlotsView recipeCategorySlotsView = () -> Collections.unmodifiableList(this.recipeCategorySlots);
        RecipeSlotUnderMouse hoveredSlotResult = this.getSlotUnderMouse(mouseX, mouseY).orElse(null);
        PoseStack poseStack = guiGraphics.pose();
        if (hoveredSlotResult != null) {
            IRecipeSlotDrawable hoveredSlot = hoveredSlotResult.slot();
            poseStack.pushPose();
            ScreenPosition offset = hoveredSlotResult.offset();
            poseStack.translate((float)offset.x(), (float)offset.y(), 0.0f);
            hoveredSlot.drawHoverOverlays(guiGraphics);
            poseStack.popPose();
            JeiTooltip tooltip = new JeiTooltip();
            hoveredSlot.getTooltip(tooltip);
            tooltip.draw(guiGraphics, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.recipeCategory.getTooltip(tooltip, this.recipe, recipeCategorySlotsView, recipeMouseX, recipeMouseY);
            for (IRecipeCategoryDecorator<R> decorator : this.recipeCategoryDecorators) {
                decorator.decorateTooltips(tooltip, this.recipe, this.recipeCategory, recipeCategorySlotsView, recipeMouseX, recipeMouseY);
            }
            if (tooltip.isEmpty() && this.shapelessIcon != null && this.shapelessIcon.isMouseOver(recipeMouseX, recipeMouseY)) {
                this.shapelessIcon.addTooltip(tooltip);
            }
            tooltip.draw(guiGraphics, mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return MathUtil.contains(this.area, mouseX, mouseY);
    }

    @Override
    public Rect2i getRect() {
        return this.area.toMutable();
    }

    @Override
    public Rect2i getRectWithBorder() {
        return this.area.expandBy(this.recipeBorderPadding).toMutable();
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot).flatMap(slot -> slot.getDisplayedIngredient(ingredientType));
    }

    @Override
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return this.getSlotUnderMouse(mouseX, mouseY).map(RecipeSlotUnderMouse::slot);
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        double recipeMouseX = mouseX - (double)this.area.getX();
        double recipeMouseY = mouseY - (double)this.area.getY();
        for (ISlottedRecipeWidget widget : this.slottedWidgets) {
            double relativeMouseY;
            ScreenPosition position;
            double relativeMouseX;
            Optional<RecipeSlotUnderMouse> slotResult = widget.getSlotUnderMouse(relativeMouseX = recipeMouseX - (double)(position = widget.getPosition()).x(), relativeMouseY = recipeMouseY - (double)position.y());
            if (!slotResult.isPresent()) continue;
            return slotResult.map(slot -> slot.addOffset(this.area.x(), this.area.y()));
        }
        for (IRecipeSlotDrawable slot2 : this.recipeCategorySlots) {
            if (!slot2.isMouseOver(recipeMouseX, recipeMouseY)) continue;
            return Optional.of(new RecipeSlotUnderMouse(slot2, this.area.getScreenPosition()));
        }
        return Optional.empty();
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public Rect2i getRecipeTransferButtonArea() {
        return this.recipeTransferButtonArea.toMutable();
    }

    @Override
    public Rect2i getRecipeBookmarkButtonArea() {
        Rect2i area = this.getRecipeTransferButtonArea();
        area.setPosition(area.getX(), area.getY() - area.getHeight() - 2);
        return area;
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return () -> Collections.unmodifiableList(this.allSlots);
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void tick() {
        for (IRecipeWidget widget : this.allWidgets) {
            widget.tick();
        }
        if (this.cycleTicker.tick()) {
            for (IRecipeSlotDrawable slot : this.recipeCategorySlots) {
                slot.clearDisplayOverrides();
            }
            this.recipeCategory.onDisplayedIngredientsUpdate(this.recipe, this.recipeCategorySlots, this.focuses);
        }
    }
}

