/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import com.mojang.serialization.Codec;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.library.render.FluidTankRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidHelper
implements IPlatformFluidHelperInternal<FluidStack> {
    @Override
    public IIngredientTypeWithSubtypes<Fluid, FluidStack> getFluidIngredientType() {
        return ForgeTypes.FLUID_STACK;
    }

    @Override
    public IIngredientRenderer<FluidStack> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<FluidStack>(this, capacity, showCapacity, width, height);
    }

    @Override
    public int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    @Override
    public long getAmount(FluidStack ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public FluidStack copyWithAmount(FluidStack ingredient, long amount) {
        FluidStack copy = ingredient.copy();
        int intAmount = Math.toIntExact(amount);
        copy.setAmount(intAmount);
        return copy;
    }

    @Override
    public DataComponentPatch getComponentsPatch(FluidStack ingredient) {
        return DataComponentPatch.EMPTY;
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, FluidStack ingredient, TooltipFlag tooltipFlag) {
        ResourceLocation resourceLocation;
        Fluid fluid = ingredient.getFluid();
        if (fluid.isSame(Fluids.EMPTY)) {
            return;
        }
        Component displayName = this.getDisplayName(ingredient);
        tooltip.add((FormattedText)displayName);
        if (tooltipFlag.isAdvanced() && (resourceLocation = ForgeRegistries.FLUIDS.getKey((Object)fluid)) != null) {
            MutableComponent advancedId = Component.literal((String)resourceLocation.toString()).withStyle(ChatFormatting.DARK_GRAY);
            tooltip.add((FormattedText)advancedId);
        }
    }

    @Override
    public long bucketVolume() {
        return 1000L;
    }

    @Override
    public Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        return Optional.ofNullable(fluidStill).map(f -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(f)).filter(s -> s.atlasLocation() != MissingTextureAtlasSprite.getLocation());
    }

    @Override
    public Component getDisplayName(FluidStack ingredient) {
        Component displayName = ingredient.getDisplayName();
        Fluid fluid = ingredient.getFluid();
        if (!fluid.isSource(fluid.defaultFluidState())) {
            return Component.translatable((String)"jei.tooltip.liquid.flowing", (Object[])new Object[]{displayName});
        }
        return displayName;
    }

    @Override
    public FluidStack create(Holder<Fluid> fluid, long amount) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack((Fluid)fluid.value(), intAmount);
    }

    @Override
    public FluidStack create(Holder<Fluid> fluid, long amount, DataComponentPatch components) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack((Fluid)fluid.value(), intAmount);
    }

    @Override
    public FluidStack copy(FluidStack ingredient) {
        return ingredient.copy();
    }

    @Override
    public FluidStack normalize(FluidStack ingredient) {
        if (ingredient.getAmount() == 1000) {
            return ingredient;
        }
        FluidStack copy = this.copy(ingredient);
        copy.setAmount(1000);
        return copy;
    }

    @Override
    public Optional<FluidStack> getContainedFluid(ITypedIngredient<?> ingredient) {
        return Optional.empty();
    }

    @Override
    public Codec<FluidStack> getCodec() {
        return FluidStack.CODEC;
    }
}

