package mezz.jei.library.color;

import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_3532;
import net.minecraft.class_763;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ColorGetter {
	private static final Logger LOGGER = LogManager.getLogger();

	public ColorGetter() {

	}

	public List<Integer> getColors(class_1799 itemStack, int colorCount) {
		try {
			return unsafeGetColors(itemStack, colorCount);
		} catch (RuntimeException | LinkageError e) {
			String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
			LOGGER.warn("Failed to get color name for {}", itemStackInfo, e);
			return Collections.emptyList();
		}
	}

	private List<Integer> unsafeGetColors(class_1799 itemStack, int colorCount) {
		final class_1792 item = itemStack.method_7909();
		if (itemStack.method_7960()) {
			return Collections.emptyList();
		} else if (item instanceof final class_1747 itemBlock) {
			final class_2248 block = itemBlock.method_7711();
			//noinspection ConstantConditions
			if (block == null) {
				return Collections.emptyList();
			}
			return getBlockColors(block, colorCount);
		} else {
			return getItemColors(itemStack, colorCount);
		}
	}

	private List<Integer> getItemColors(class_1799 itemStack, int colorCount) {
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		final class_325 itemColors = renderHelper.getItemColors();
		final int renderColor = itemColors.method_1704(itemStack, 0);
		final class_1058 textureAtlasSprite = getTextureAtlasSprite(itemStack);
		if (textureAtlasSprite == null) {
			return Collections.emptyList();
		}
		return getColors(textureAtlasSprite, renderColor, colorCount);
	}

	private List<Integer> getBlockColors(class_2248 block, int colorCount) {
		class_2680 blockState = block.method_9564();
		final class_324 blockColors = class_310.method_1551().method_1505();
		final int renderColor = blockColors.method_1697(blockState, null, null, 0);
		final class_1058 textureAtlasSprite = getTextureAtlasSprite(blockState);
		if (textureAtlasSprite == null) {
			return Collections.emptyList();
		}
		return getColors(textureAtlasSprite, renderColor, colorCount);
	}

	public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
		if (colorCount <= 0) {
			return Collections.emptyList();
		}
		return getNativeImage(textureAtlasSprite)
			.map(bufferedImage -> {
				final List<Integer> colors = new ArrayList<>(colorCount);
				final int[][] palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false);
				for (int[] colorInt : palette) {
					int red = (int) ((colorInt[0] - 1) * (float) (renderColor >> 16 & 255) / 255.0F);
					int green = (int) ((colorInt[1] - 1) * (float) (renderColor >> 8 & 255) / 255.0F);
					int blue = (int) ((colorInt[2] - 1) * (float) (renderColor & 255) / 255.0F);
					red = class_3532.method_15340(red, 0, 255);
					green = class_3532.method_15340(green, 0, 255);
					blue = class_3532.method_15340(blue, 0, 255);
					int color = ((0xFF) << 24) |
						((red & 0xFF) << 16) |
						((green & 0xFF) << 8) |
						(blue & 0xFF);
					colors.add(color);
				}
				return colors;
			})
			.orElseGet(Collections::emptyList);
	}

	private static Optional<class_1011> getNativeImage(class_1058 textureAtlasSprite) {
		class_7764 contents = textureAtlasSprite.method_45851();
		int iconWidth = contents.method_45807();
		int iconHeight = contents.method_45815();
		if (iconWidth <= 0 || iconHeight <= 0) {
			return Optional.empty();
		}

		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		return renderHelper.getMainImage(textureAtlasSprite);
	}

	@Nullable
	private static class_1058 getTextureAtlasSprite(class_2680 blockState) {
		class_310 minecraft = class_310.method_1551();
		class_776 blockRendererDispatcher = minecraft.method_1541();
		class_773 blockModelShapes = blockRendererDispatcher.method_3351();
		class_1087 blockModel = blockModelShapes.method_3335(blockState);
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		class_1058 textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
		if (textureAtlasSprite.method_45852().equals(class_1047.method_4539())) {
			return null;
		}
		return textureAtlasSprite;
	}

	@Nullable
	private static class_1058 getTextureAtlasSprite(class_1799 itemStack) {
		class_918 itemRenderer = class_310.method_1551().method_1480();
		class_763 itemModelMesher = itemRenderer.method_4012();
		class_1087 itemModel = itemModelMesher.method_3308(itemStack);
		IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
		class_1058 particleTexture = renderHelper.getParticleIcon(itemModel);
		if (particleTexture.method_45852().equals(class_1047.method_4539())) {
			return null;
		}
		return particleTexture;
	}
}
