/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.color.ColorThief;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_3532;
import net.minecraft.class_763;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_7764;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ColorGetter {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<Integer> getColors(class_1799 itemStack, int colorCount) {
        try {
            return this.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.warn("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<Integer> unsafeGetColors(class_1799 itemStack, int colorCount) {
        class_1792 item = itemStack.method_7909();
        if (itemStack.method_7960()) {
            return Collections.emptyList();
        }
        if (item instanceof class_1747) {
            class_1747 itemBlock = (class_1747)item;
            class_2248 block = itemBlock.method_7711();
            if (block == null) {
                return Collections.emptyList();
            }
            return this.getBlockColors(block, colorCount);
        }
        return this.getItemColors(itemStack, colorCount);
    }

    private List<Integer> getItemColors(class_1799 itemStack, int colorCount) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_325 itemColors = renderHelper.getItemColors();
        int renderColor = itemColors.method_1704(itemStack, 0);
        class_1058 textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return this.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private List<Integer> getBlockColors(class_2248 block, int colorCount) {
        class_2680 blockState = block.method_9564();
        class_324 blockColors = class_310.method_1551().method_1505();
        int renderColor = blockColors.method_1697(blockState, null, null, 0);
        class_1058 textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return this.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        return ColorGetter.getNativeImage(textureAtlasSprite).map(bufferedImage -> {
            int[][] palette;
            ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
            for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = class_3532.method_15340((int)red, (int)0, (int)255);
                green = class_3532.method_15340((int)green, (int)0, (int)255);
                blue = class_3532.method_15340((int)blue, (int)0, (int)255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
            return colors;
        }).orElseGet(Collections::emptyList);
    }

    private static Optional<class_1011> getNativeImage(class_1058 textureAtlasSprite) {
        class_7764 contents = textureAtlasSprite.method_45851();
        int iconWidth = contents.method_45807();
        int iconHeight = contents.method_45815();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return Optional.empty();
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getMainImage(textureAtlasSprite);
    }

    @Nullable
    private static class_1058 getTextureAtlasSprite(class_2680 blockState) {
        class_310 minecraft = class_310.method_1551();
        class_776 blockRendererDispatcher = minecraft.method_1541();
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        class_1087 blockModel = blockModelShapes.method_3335(blockState);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_1058 textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
        if (textureAtlasSprite.method_45852().equals((Object)class_1047.method_4539())) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static class_1058 getTextureAtlasSprite(class_1799 itemStack) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_763 itemModelMesher = itemRenderer.method_4012();
        class_1087 itemModel = itemModelMesher.method_3308(itemStack);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_1058 particleTexture = renderHelper.getParticleIcon(itemModel);
        if (particleTexture.method_45852().equals((Object)class_1047.method_4539())) {
            return null;
        }
        return particleTexture;
    }
}

