package mezz.jei.fabric.input;

import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifiers;
import mezz.jei.common.input.keys.JeiKeyConflictContext;
import mezz.jei.common.input.keys.JeiKeyModifier;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import java.util.List;

public class AmecsJeiKeyMapping extends AbstractJeiKeyMapping {
	protected final class_304 amecsMapping;

	public AmecsJeiKeyMapping(AmecsKeyBindingWithContext amecsMapping, JeiKeyConflictContext context) {
		super(context);
		this.amecsMapping = amecsMapping;
	}

	@Override
	protected class_304 getMapping() {
		return this.amecsMapping;
	}

	@Override
	public boolean isActiveAndMatches(class_3675.class_306 key) {
		if (isUnbound()) {
			return false;
		}
		if (!KeyBindingHelper.getBoundKeyOf(this.amecsMapping).equals(key)) {
			return false;
		}
		if (!context.isActive()) {
			return false;
		}

		KeyModifiers modifiers = KeyBindingUtils.getBoundModifiers(this.amecsMapping);
		List<JeiKeyModifier> jeiKeyModifiers = AmecsHelper.getJeiModifiers(modifiers);
		for (JeiKeyModifier jeiKeyModifier : jeiKeyModifiers) {
			if (!jeiKeyModifier.isActive(context)) {
				return false;
			}
		}
		return true;
	}
}
