package mezz.jei.library.plugins.vanilla.ingredients.subtypes;

import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.class_1799;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class SuspiciousStewSubtypeInterpreter implements ISubtypeInterpreter<class_1799> {
	public static final SuspiciousStewSubtypeInterpreter INSTANCE = new SuspiciousStewSubtypeInterpreter();

	private SuspiciousStewSubtypeInterpreter() {

	}

	@Override
	public @Nullable Object getSubtypeData(class_1799 ingredient, UidContext context) {
		return ingredient.method_57824(class_9334.field_49652);
	}

	@Override
	public String getLegacyStringSubtypeInfo(class_1799 itemStack, UidContext context) {
		class_9298 suspiciousStewEffects = itemStack.method_57824(class_9334.field_49652);
		if (suspiciousStewEffects == null) {
			return "";
		}
		List<class_9298.class_8751> effects = suspiciousStewEffects.comp_2416();
		List<String> strings = new ArrayList<>();
		for (class_9298.class_8751 e : effects) {
			String effect = e.comp_1838().method_55840();
			int duration = e.comp_1839();
			strings.add(effect + "." + duration);
		}

		StringJoiner joiner = new StringJoiner(",", "[", "]");
		strings.sort(null);
		for (String s : strings) {
			joiner.add(s);
		}
		return joiner.toString();
	}
}
