package mezz.jei.library.plugins.vanilla.cooking;

import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_2246;
import net.minecraft.class_3920;
import net.minecraft.class_8786;

public class CampfireCookingCategory extends AbstractCookingCategory<class_3920> {
	public CampfireCookingCategory(IGuiHelper guiHelper) {
		super(guiHelper, RecipeTypes.CAMPFIRE_COOKING, class_2246.field_17350, "gui.jei.category.campfire", 400, 82, 44);
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_3920> recipeHolder, IFocusGroup focuses) {
		class_3920 recipe = recipeHolder.comp_1933();
		builder.addInputSlot(1, 1)
			.setStandardSlotBackground()
			.addIngredients(recipe.method_8117().getFirst());

		builder.addOutputSlot(61, 9)
			.setOutputSlotBackground()
			.addItemStack(RecipeUtil.getResultItem(recipe));
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8786<class_3920> recipeHolder, IFocusGroup focuses) {
		class_3920 recipe = recipeHolder.comp_1933();
		int cookTime = recipe.method_8167();
		if (cookTime <= 0) {
			cookTime = regularCookTime;
		}
		builder.addAnimatedRecipeArrow(cookTime)
			.setPosition(26, 7);
		builder.addAnimatedRecipeFlame(300)
			.setPosition(1, 20);

		addCookTime(builder, recipeHolder);
	}
}
