/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.util.Optional;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.elements.InternalIconButton;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public final class IconButton {
    private final InternalIconButton button;
    private final IIconButtonController controller;
    private ImmutableRect2i area;

    public IconButton(IIconButtonController controller) {
        this(controller, ImmutableRect2i.EMPTY);
    }

    public IconButton(IIconButtonController controller, ImmutableRect2i area) {
        this.controller = controller;
        this.button = new InternalIconButton();
        this.area = area;
        this.controller.initState(this.button);
    }

    public void updateBounds(ImmutableRect2i area) {
        this.button.updateBounds(area);
        this.area = area;
    }

    public ImmutableRect2i getArea() {
        return this.area;
    }

    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.area.isEmpty()) {
            return;
        }
        this.button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.controller.drawExtras(guiGraphics, this.area.toMutable(), mouseX, mouseY, partialTicks);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.button.field_22764 && this.area.contains(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new UserInputHandler(this.button, this.controller);
    }

    public void tick() {
        this.controller.updateState(this.button);
    }

    public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            JeiTooltip tooltip = new JeiTooltip();
            this.controller.getTooltips(tooltip);
            tooltip.draw(guiGraphics, mouseX, mouseY);
        }
    }

    public boolean isVisible() {
        return this.button.field_22764;
    }

    public int getX() {
        return this.area.getX();
    }

    public int getY() {
        return this.area.getY();
    }

    public int getWidth() {
        return this.area.getWidth();
    }

    public int getHeight() {
        return this.area.getHeight();
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final InternalIconButton button;
        private final IIconButtonController controller;

        public UserInputHandler(InternalIconButton button, IIconButtonController controller) {
            this.button = button;
            this.controller = controller;
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
            this.button.setPressed(false);
            double mouseX = input.getMouseX();
            double mouseY = input.getMouseY();
            if (!(this.button.field_22763 && this.button.field_22764 && this.button.method_25405(mouseX, mouseY))) {
                return Optional.empty();
            }
            if (!this.button.method_25351(input.getKey().method_1444())) {
                return Optional.empty();
            }
            boolean flag = this.button.method_25361(mouseX, mouseY);
            if (!flag) {
                return Optional.empty();
            }
            if (!input.isSimulate()) {
                this.button.method_25354(class_310.method_1551().method_1483());
            } else {
                this.button.setPressed(true);
            }
            this.controller.onPress(input);
            return Optional.of(this);
        }

        @Override
        public void unfocus() {
            this.button.setPressed(false);
        }
    }
}

