package mezz.jei.library.plugins.vanilla.ingredients.fluid;

import com.google.common.base.MoreObjects;
import mezz.jei.api.constants.Tags;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.TagUtil;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class FluidIngredientHelper<T> implements IIngredientHelper<T> {
	private final ISubtypeManager subtypeManager;
	private final IColorHelper colorHelper;
	private final IPlatformFluidHelperInternal<T> platformFluidHelper;
	private final class_2378<class_3611> registry;
	private final IIngredientTypeWithSubtypes<class_3611, T> fluidType;
	private final class_6862<class_3611> hiddenFromRecipeViewers;

	public FluidIngredientHelper(ISubtypeManager subtypeManager, IColorHelper colorHelper, IPlatformFluidHelperInternal<T> platformFluidHelper) {
		this.subtypeManager = subtypeManager;
		this.colorHelper = colorHelper;
		this.platformFluidHelper = platformFluidHelper;
		this.registry = RegistryUtil.getRegistry(class_7924.field_41270);
		this.fluidType = platformFluidHelper.getFluidIngredientType();
		//noinspection deprecation
		this.hiddenFromRecipeViewers = new class_6862<>(class_7924.field_41270, Tags.HIDDEN_FROM_RECIPE_VIEWERS);
	}

	@Override
	public IIngredientTypeWithSubtypes<class_3611, T> getIngredientType() {
		return fluidType;
	}

	@Override
	public String getDisplayName(T ingredient) {
		class_2561 displayName = platformFluidHelper.getDisplayName(ingredient);
		return displayName.getString();
	}

	@SuppressWarnings("removal")
	@Override
	public String getUniqueId(T ingredient, UidContext context) {
		class_3611 fluid = fluidType.getBase(ingredient);
		class_2960 registryName = getRegistryName(ingredient, fluid);

		StringBuilder result = new StringBuilder()
			.append("fluid:")
			.append(registryName);

		String subtypeInfo = subtypeManager.getSubtypeInfo(fluidType, ingredient, context);
		if (!subtypeInfo.isEmpty()) {
			result.append(":");
			result.append(subtypeInfo);
		}

		return result.toString();
	}

	@Override
	public Object getGroupingUid(T ingredient) {
		return fluidType.getBase(ingredient);
	}

	@SuppressWarnings("removal")
	@Override
	public String getWildcardId(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);
		class_2960 registryName = getRegistryName(ingredient, fluid);
		return "fluid:" + registryName;
	}

	@Override
	public Object getUid(T ingredient, UidContext context) {
		class_3611 fluid = fluidType.getBase(ingredient);
		Object subtypeData = subtypeManager.getSubtypeData(fluidType, ingredient, context);
		if (subtypeData != null) {
			return List.of(fluid, subtypeData);
		}
		return fluid;
	}

	@Override
	public long getAmount(T ingredient) {
		return platformFluidHelper.getAmount(ingredient);
	}

	@Override
	public T copyWithAmount(T ingredient, long amount) {
		return platformFluidHelper.copyWithAmount(ingredient, amount);
	}

	@Override
	public Iterable<Integer> getColors(T ingredient) {
		return platformFluidHelper.getStillFluidSprite(ingredient)
			.map(fluidStillSprite -> {
				int renderColor = platformFluidHelper.getColorTint(ingredient);
				return colorHelper.getColors(fluidStillSprite, renderColor, 1);
			})
			.orElseGet(List::of);
	}

	@Override
	public class_2960 getResourceLocation(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);
		return getRegistryName(ingredient, fluid);
	}

	private class_2960 getRegistryName(T ingredient, class_3611 fluid) {
		class_2960 key = registry.method_10221(fluid);
		if (key == null) {
			String ingredientInfo = getErrorInfo(ingredient);
			throw new IllegalStateException("null registry name for: " + ingredientInfo);
		}
		return key;
	}

	@Override
	public class_1799 getCheatItemStack(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);
		class_1792 filledBucket = fluid.method_15774();
		return filledBucket.method_7854();
	}

	@Override
	public T copyIngredient(T ingredient) {
		return platformFluidHelper.copy(ingredient);
	}

	@Override
	public T normalizeIngredient(T ingredient) {
		return platformFluidHelper.normalize(ingredient);
	}

	@Override
	public Stream<class_2960> getTagStream(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);

		return registry.method_29113(fluid)
			.flatMap(registry::method_40264)
			.map(class_6880::method_40228)
			.orElse(Stream.of())
			.map(class_6862::comp_327);
	}

	@Override
	public boolean isHiddenFromRecipeViewersByTags(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);
		return registry.method_29113(fluid)
			.flatMap(registry::method_40264)
			.map(holder -> holder.method_40220(hiddenFromRecipeViewers))
			.orElse(false);
	}

	@SuppressWarnings("ConstantConditions")
	@Override
	public String getErrorInfo(@Nullable T ingredient) {
		if (ingredient == null) {
			return "null";
		}
		MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
		class_3611 fluid = fluidType.getBase(ingredient);
		if (fluid != null) {
			class_2561 displayName = platformFluidHelper.getDisplayName(ingredient);
			toStringHelper.add("Fluid", displayName.getString());
		} else {
			toStringHelper.add("Fluid", "null");
		}

		toStringHelper.add("Amount", platformFluidHelper.getAmount(ingredient));

		class_9326 components = platformFluidHelper.getComponentsPatch(ingredient);
		if (!components.method_57848()) {
			toStringHelper.add("Components", components.toString());
		}

		return toStringHelper.toString();
	}

	@Override
	public Optional<class_6862<?>> getTagKeyEquivalent(Collection<T> ingredients) {
		class_2378<class_3611> fluidRegistry = RegistryUtil.getRegistry(class_7924.field_41270);
		return TagUtil.getTagEquivalent(ingredients, fluidType::getBase, fluidRegistry::method_40272);
	}

	@Override
	public boolean isIngredientOnServer(T ingredient) {
		class_3611 fluid = fluidType.getBase(ingredient);
		class_2378<class_3611> registry = RegistryUtil.getRegistry(class_7924.field_41270);
		return registry.method_10221(fluid) != null;
	}
}
