package mezz.jei.library.plugins.debug;

import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FluidSubtypeHandlerTest<T> implements ISubtypeInterpreter<T> {
	private final IIngredientTypeWithSubtypes<class_3611, T> fluidType;

	public FluidSubtypeHandlerTest(IIngredientTypeWithSubtypes<class_3611, T> fluidType) {
		this.fluidType = fluidType;
	}

	@Override
	public @Nullable Object getSubtypeData(T ingredient, UidContext context) {
		return fluidType.getBase(ingredient);
	}

	@Override
	public String getLegacyStringSubtypeInfo(T fluidStack, UidContext context) {
		class_3611 fluid = fluidType.getBase(fluidStack);
		class_2960 key = RegistryUtil
			.getRegistry(class_7924.field_41270)
			.method_10221(fluid);
		if (key == null) {
			throw new IllegalArgumentException("Fluid has no registry key: " + fluid);
		}
		return key.toString();
	}
}
