package mezz.jei.gui.input.focus;

import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_342;

public class EditBoxFocusHandler implements IFocusHandler {
	private final class_342 editBox;
	private final boolean canLoseFocus;

	public EditBoxFocusHandler(class_342 editBox) {
		this.editBox = editBox;
		IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
		this.canLoseFocus = screenHelper.canLoseFocus(this.editBox);
	}

	@Override
	public void unFocus() {
		if (editBox.method_25370()) {
			if (!canLoseFocus) {
				this.editBox.method_1856(true);
			}
			this.editBox.method_25365(false);
		}
	}

	@Override
	public void focus() {
		if (!editBox.method_25370()) {
			this.editBox.method_25365(true);
			if (!canLoseFocus) {
				this.editBox.method_1856(false);
			}
		}
	}
}
