package mezz.jei.common.util;

import mezz.jei.core.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class StringUtil {
	private StringUtil() {

	}

	public static class_2561 stripStyling(class_2561 textComponent) {
		class_5250 text = textComponent.method_27662();
		for (class_2561 sibling : textComponent.method_10855()) {
			text.method_10852(stripStyling(sibling));
		}
		return text;
	}

	public static String removeChatFormatting(String string) {
		return class_124.method_539(string);
	}

	public static class_5348 truncateStringToWidth(class_5348 text, int width, class_327 font) {
		int ellipsisWidth = font.method_1727("...");
		class_5225 splitter = font.method_27527();

		class_5348 truncatedText = font.method_1714(text, width - ellipsisWidth);

		class_2583 style = splitter.method_27489(text, width - ellipsisWidth);
		if (style == null) {
			style = class_2583.field_24360;
		}

		return class_5348.method_29433(truncatedText, class_2561.method_43470("...").method_10862(style));
	}

	/**
	 * Split and wrap lines, and truncate the last line if it exceeds the max lines.
	 * @return the wrapped lines, and a boolean indicating if the last line was truncated.
	 */
	public static Pair<List<class_5348>, Boolean> splitLines(class_327 font, List<class_5348> lines, int width, int maxLines) {
		if (lines.isEmpty()) {
			return new Pair<>(List.of(), false);
		}
		if (maxLines <= 0) {
			return new Pair<>(List.of(), true);
		}
		if (width <= 0) {
			return new Pair<>(List.copyOf(lines), false);
		}

		class_5225 splitter = font.method_27527();
		List<class_5348> result = new ArrayList<>();
		for (class_5348 line : lines) {
			List<class_5348> splitLines;
			if (line.getString().isEmpty()) {
				splitLines = List.of(line);
			} else {
				splitLines = splitter.method_27495(line, width, class_2583.field_24360);
			}

			for (class_5348 splitLine : splitLines) {
				if (result.size() == maxLines) {
					// result is at the max size, but we still have more to add.
					// Truncate the last line to indicate that there is more text that can't be displayed.
					class_5348 last = result.removeLast();
					last = truncateStringToWidth(last, width, font);
					result.add(last);
					return new Pair<>(result, true);
				}
				result.add(splitLine);
			}

		}

		return new Pair<>(result, false);
	}

	public static List<class_5348> expandNewlines(class_2561... descriptionComponents) {
		List<class_5348> descriptionLinesExpanded = new ArrayList<>();
		for (class_2561 descriptionLine : descriptionComponents) {
			ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
			descriptionLine.method_27658(newLineTextAcceptor, class_2583.field_24360);
			newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
		}
		return descriptionLinesExpanded;
	}

	public static String intsToString(Collection<Integer> indexes) {
		return indexes.stream()
			.sorted()
			.map(i -> Integer.toString(i))
			.collect(Collectors.joining(", "));
	}

	public static void drawCenteredStringWithShadow(class_332 guiGraphics, class_327 font, String string, ImmutableRect2i area) {
		ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
		guiGraphics.method_25303(font, string, textArea.getX(), textArea.getY(), 0xFFFFFFFF);
	}

	public static void drawCenteredStringWithShadow(class_332 guiGraphics, class_327 font, class_5481 text, ImmutableRect2i area) {
		ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, text);
		guiGraphics.method_35720(font, text, textArea.getX(), textArea.getY(), 0xFFFFFFFF);
	}
}
