/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.history;

import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.buttons.IButtonState;
import mezz.jei.api.gui.buttons.IIconButtonController;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.gui.textures.Textures;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5348;

public class LookupHistoryButtonController
implements IIconButtonController {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final IClientConfig clientConfig;

    public LookupHistoryButtonController(IClientConfig clientConfig) {
        Textures textures = Internal.getTextures();
        this.offIcon = textures.getHistoryButtonDisabledIcon();
        this.onIcon = textures.getHistoryButtonEnabledIcon();
        this.clientConfig = clientConfig;
    }

    @Override
    public void getTooltips(ITooltipBuilder tooltip) {
        if (this.clientConfig.isLookupHistoryEnabled()) {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.lookupHistory.disable"));
        } else {
            tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.lookupHistory.enable"));
        }
        tooltip.add((class_5348)class_2561.method_43471((String)"jei.tooltip.lookupHistory.usage").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
    }

    @Override
    public void updateState(IButtonState state) {
        state.setForcePressed(this.clientConfig.isLookupHistoryEnabled());
        if (this.clientConfig.isLookupHistoryEnabled()) {
            state.setIcon(this.onIcon);
        } else {
            state.setIcon(this.offIcon);
        }
    }

    @Override
    public boolean onPress(IJeiUserInput input) {
        if (!input.isSimulate()) {
            this.clientConfig.setLookupHistoryEnabled(!this.clientConfig.isLookupHistoryEnabled());
        }
        return true;
    }
}

