/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IScrollBoxWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.OffsetJeiInputHandler;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_8029;

public class RecipeLayoutDrawableErrored<R>
implements IRecipeLayoutDrawable<R> {
    private final IRecipeCategory<R> recipeCategory;
    private final R recipe;
    private final IScrollBoxWidget scrollBoxWidget;
    private final IJeiInputHandler inputHandler;
    private final IScalableDrawable background;
    private final int borderPadding;
    private ImmutableRect2i area;

    public RecipeLayoutDrawableErrored(IRecipeCategory<R> recipeCategory, R recipe, IScalableDrawable background, int borderPadding) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.area = new ImmutableRect2i(0, 0, Math.max(100, recipeCategory.getWidth()), recipeCategory.getHeight());
        this.background = background;
        this.borderPadding = borderPadding;
        ArrayList<class_5348> lines = new ArrayList<class_5348>();
        lines.add((class_5348)class_2561.method_43471((String)"gui.jei.category.recipe.crashed").method_27692(class_124.field_1061));
        class_2960 registryName = recipeCategory.getRegistryName(recipe);
        if (registryName != null) {
            lines.add((class_5348)class_2561.method_43470((String)registryName.toString()).method_27692(class_124.field_1080));
        }
        lines.add((class_5348)class_2561.method_43473());
        lines.add((class_5348)class_2561.method_43470((String)recipeCategory.getRecipeType().getUid().toString()).method_27692(class_124.field_1080));
        IJeiRuntime jeiRuntime = Internal.getJeiRuntime();
        IJeiHelpers jeiHelpers = jeiRuntime.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        this.scrollBoxWidget = guiHelper.createScrollBoxWidget(this.area.width(), this.area.getHeight(), 0, 0).setContents(lines);
        this.inputHandler = new OffsetJeiInputHandler(this.scrollBoxWidget, this::getScreenPosition);
    }

    private class_8029 getScreenPosition() {
        return this.area.getScreenPosition();
    }

    @Override
    public void setPosition(int posX, int posY) {
        this.area = this.area.setPosition(posX, posY);
    }

    @Override
    public void drawRecipe(class_332 guiGraphics, int mouseX, int mouseY) {
        this.background.draw(guiGraphics, this.getRectWithBorder());
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)this.area.x(), (float)this.area.y(), 0.0f);
        int recipeMouseX = mouseX - this.area.x();
        int recipeMouseY = mouseY - this.area.y();
        class_8029 position = this.scrollBoxWidget.getPosition();
        poseStack.method_22903();
        poseStack.method_46416((float)position.comp_1193(), (float)position.comp_1194(), 0.0f);
        this.scrollBoxWidget.drawWidget(guiGraphics, recipeMouseX - position.comp_1193(), recipeMouseY - position.comp_1194());
        poseStack.method_22909();
        poseStack.method_22909();
    }

    @Override
    public void drawOverlays(class_332 guiGraphics, int mouseX, int mouseY) {
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    @Override
    public <T> Optional<T> getIngredientUnderMouse(int mouseX, int mouseY, IIngredientType<T> ingredientType) {
        return Optional.empty();
    }

    @Override
    public Optional<IRecipeSlotDrawable> getRecipeSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
        return Optional.empty();
    }

    @Override
    public class_768 getRect() {
        return this.area.toMutable();
    }

    @Override
    public class_768 getRectWithBorder() {
        return this.area.expandBy(this.borderPadding).toMutable();
    }

    @Override
    public class_768 getSideButtonArea(int buttonIndex) {
        return new class_768(0, 0, 0, 0);
    }

    @Override
    public IRecipeSlotsView getRecipeSlotsView() {
        return List::of;
    }

    @Override
    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    @Override
    public R getRecipe() {
        return this.recipe;
    }

    @Override
    public IJeiInputHandler getInputHandler() {
        return this.inputHandler;
    }

    @Override
    public void tick() {
    }
}

