/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.transfer;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.common.Internal;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableSize2i;
import mezz.jei.library.gui.helpers.CraftingGridHelper;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.transfer.BasicRecipeTransferHandler;
import mezz.jei.library.transfer.BasicRecipeTransferInfo;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.minecraft.class_1703;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferHandlerHelper
implements IRecipeTransferHandlerHelper {
    private final IStackHelper stackHelper;
    private final CraftingRecipeCategory craftingRecipeCategory;

    public RecipeTransferHandlerHelper(IStackHelper stackHelper, CraftingRecipeCategory craftingRecipeCategory) {
        this.stackHelper = stackHelper;
        this.craftingRecipeCategory = craftingRecipeCategory;
    }

    @Override
    public IRecipeTransferError createInternalError() {
        return RecipeTransferErrorInternal.INSTANCE;
    }

    @Override
    public IRecipeTransferError createUserErrorWithTooltip(class_2561 tooltipMessage) {
        ErrorUtil.checkNotNull(tooltipMessage, "tooltipMessage");
        return new RecipeTransferErrorTooltip(tooltipMessage);
    }

    @Override
    public <C extends class_1703, R> IRecipeTransferInfo<C, R> createBasicRecipeTransferInfo(Class<? extends C> containerClass, @Nullable class_3917<C> menuType, RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, "containerClass");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        return new BasicRecipeTransferInfo<C, R>(containerClass, menuType, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
    }

    @Override
    public <C extends class_1703, R> IRecipeTransferHandler<C, R> createUnregisteredRecipeTransferHandler(IRecipeTransferInfo<C, R> recipeTransferInfo) {
        ErrorUtil.checkNotNull(recipeTransferInfo, "recipeTransferInfo");
        IConnectionToServer serverConnection = Internal.getServerConnection();
        return new BasicRecipeTransferHandler<C, R>(serverConnection, this.stackHelper, this, recipeTransferInfo);
    }

    @Override
    public IRecipeTransferError createUserErrorForMissingSlots(class_2561 tooltipMessage, Collection<IRecipeSlotView> missingItemSlots) {
        ErrorUtil.checkNotNull(tooltipMessage, "tooltipMessage");
        ErrorUtil.checkNotEmpty(missingItemSlots, "missingItemSlots");
        return new RecipeTransferErrorMissingSlots(tooltipMessage, missingItemSlots);
    }

    @Override
    public IRecipeSlotsView createRecipeSlotsView(List<IRecipeSlotView> slotViews) {
        return () -> slotViews;
    }

    @Override
    public boolean recipeTransferHasServerSupport() {
        IConnectionToServer serverConnection = Internal.getServerConnection();
        return serverConnection.isJeiOnServer();
    }

    @Override
    public Map<Integer, class_1856> getGuiSlotIndexToIngredientMap(class_8786<class_3955> recipeHolder) {
        ImmutableSize2i recipeSize = this.craftingRecipeCategory.getRecipeSize(recipeHolder);
        return CraftingGridHelper.getGuiSlotToIngredientMap(recipeHolder, recipeSize.width(), recipeSize.height());
    }
}

