package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.RecipeLayoutDrawableErrored;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public final class RecipeLayoutWithButtonsErrored<R> implements IRecipeLayoutWithButtons<R> {
	private final RecipeLayoutDrawableErrored<R> errorLayout;

	public RecipeLayoutWithButtonsErrored(IRecipeLayoutDrawable<R> brokenRecipeLayout) {
		DrawableNineSliceTexture recipeBackground = Internal.getTextures().getRecipeBackground();
		this.errorLayout = new RecipeLayoutDrawableErrored<>(brokenRecipeLayout.getRecipeCategory(), brokenRecipeLayout.getRecipe(), recipeBackground, 4);
		class_768 rect = brokenRecipeLayout.getRect();
		this.errorLayout.setPosition(rect.method_3321(), rect.method_3322());
	}

	@Override
	public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		errorLayout.drawRecipe(guiGraphics, mouseX, mouseY);
	}

	@Override
	public void updateBounds(int recipeXOffset, int recipeYOffset) {
		class_768 rectWithBorder = errorLayout.getRectWithBorder();
		class_768 rect = errorLayout.getRect();
		errorLayout.setPosition(
			recipeXOffset - rectWithBorder.method_3321() + rect.method_3321(),
			recipeYOffset - rectWithBorder.method_3322() + rect.method_3322()
		);
	}

	@Override
	public int totalWidth() {
		class_768 area = errorLayout.getRect();
		class_768 areaWithBorder = errorLayout.getRectWithBorder();
		int leftBorderWidth = area.method_3321() - areaWithBorder.method_3321();
		int rightAreaWidth = areaWithBorder.method_3319() - leftBorderWidth;
		return leftBorderWidth + rightAreaWidth;
	}

	@Override
	public IUserInputHandler createUserInputHandler() {
		return new CombinedInputHandler(
			"RecipeLayoutWithButtonsErrored",
			new UserInputHandler<>(errorLayout)
		);
	}

	@Override
	public void tick(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
		errorLayout.tick();
	}

	@Override
	public IRecipeLayoutDrawable<R> getRecipeLayout() {
		return errorLayout;
	}

	@Override
	public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {

	}

	@Override
	public int getMissingCountHint() {
		return Integer.MAX_VALUE;
	}

	private record UserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler {
		@Override
		public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
			final double mouseX = input.getMouseX();
			final double mouseY = input.getMouseY();
			if (recipeLayout.isMouseOver(mouseX, mouseY)) {
				if (recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
					return Optional.of(this);
				}
			}
			return Optional.empty();
		}

		@Override
		public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
			if (recipeLayout.isMouseOver(mouseX, mouseY) &&
				recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY)
			) {
				return Optional.of(this);
			}

			return Optional.empty();
		}
	}
}
