package mezz.jei.gui.recipes;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.bookmarks.BookmarkList;
import mezz.jei.gui.bookmarks.RecipeBookmark;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

public final class RecipeLayoutWithButtons<R> implements IRecipeLayoutWithButtons<R> {

	public static <T> IRecipeLayoutWithButtons<T> create(
		IRecipeLayoutDrawable<T> recipeLayoutDrawable,
		@Nullable RecipeBookmark<?, ?> recipeBookmark,
		BookmarkList bookmarks,
		RecipesGui recipesGui,
		@Nullable class_1703 container
	) {
		class_310 minecraft = class_310.method_1551();
		class_1657 player = minecraft.field_1724;
		RecipeTransferButton transferButton = RecipeTransferButton.create(recipeLayoutDrawable, recipesGui::method_25419, container, player);
		RecipeBookmarkButton bookmarkButton = RecipeBookmarkButton.create(recipeLayoutDrawable, bookmarks, recipeBookmark);
		return new RecipeLayoutWithButtons<>(recipeLayoutDrawable, transferButton, bookmarkButton);
	}

	private final IRecipeLayoutDrawable<R> recipeLayout;
	private final RecipeTransferButton transferButton;
	private final RecipeBookmarkButton bookmarkButton;

	private RecipeLayoutWithButtons(
		IRecipeLayoutDrawable<R> recipeLayout,
		RecipeTransferButton transferButton,
		RecipeBookmarkButton bookmarkButton
	) {
		this.recipeLayout = recipeLayout;
		this.transferButton = transferButton;
		this.bookmarkButton = bookmarkButton;
	}

	@Override
	public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
		recipeLayout.drawRecipe(guiGraphics, mouseX, mouseY);
		transferButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
		bookmarkButton.draw(guiGraphics, mouseX, mouseY, partialTicks);
	}

	@Override
	public void updateBounds(int recipeXOffset, int recipeYOffset) {
		class_768 rectWithBorder = recipeLayout.getRectWithBorder();
		class_768 rect = recipeLayout.getRect();
		recipeLayout.setPosition(
			recipeXOffset - rectWithBorder.method_3321() + rect.method_3321(),
			recipeYOffset - rectWithBorder.method_3322() + rect.method_3322()
		);

		class_768 layoutArea = recipeLayout.getRect();
		{
			class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
			buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
			buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
			transferButton.updateBounds(buttonArea);
		}
		{
			class_768 buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
			buttonArea.method_35778(buttonArea.method_3321() + layoutArea.method_3321());
			buttonArea.method_35781(buttonArea.method_3322() + layoutArea.method_3322());
			bookmarkButton.updateBounds(buttonArea);
		}
	}

	@Override
	public int totalWidth() {
		class_768 area = recipeLayout.getRect();
		class_768 areaWithBorder = recipeLayout.getRectWithBorder();
		int leftBorderWidth = area.method_3321() - areaWithBorder.method_3321();
		int rightAreaWidth = areaWithBorder.method_3319() - leftBorderWidth;

		if (transferButton.isVisible()) {
			class_768 buttonArea = recipeLayout.getRecipeTransferButtonArea();
			int buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
			rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
		}

		if (bookmarkButton.isVisible()) {
			class_768 buttonArea = recipeLayout.getRecipeBookmarkButtonArea();
			int buttonRight = buttonArea.method_3321() + buttonArea.method_3319();
			rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
		}

		return leftBorderWidth + rightAreaWidth;
	}

	@Override
	public IUserInputHandler createUserInputHandler() {
		return new CombinedInputHandler(
			"RecipeLayoutWithButtons",
			bookmarkButton.createInputHandler(),
			transferButton.createInputHandler(),
			new RecipeLayoutUserInputHandler<>(recipeLayout)
		);
	}

	@Override
	public void tick(@Nullable class_1703 parentContainer, @Nullable class_1657 player) {
		recipeLayout.tick();
		transferButton.update(parentContainer, player);
		bookmarkButton.tick();
	}

	@Override
	public IRecipeLayoutDrawable<R> getRecipeLayout() {
		return recipeLayout;
	}

	@Override
	public void drawTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
		transferButton.drawTooltips(guiGraphics, mouseX, mouseY);
		bookmarkButton.drawTooltips(guiGraphics, mouseX, mouseY);
	}

	@Override
	public int getMissingCountHint() {
		return transferButton.getMissingCountHint();
	}

	private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler {

		@Override
		public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput input, IInternalKeyMappings keyBindings) {
			final double mouseX = input.getMouseX();
			final double mouseY = input.getMouseY();
			if (recipeLayout.isMouseOver(mouseX, mouseY)) {
				class_3675.class_306 key = input.getKey();
				boolean simulate = input.isSimulate();

				if (recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
					return Optional.of(this);
				}

				IInternalKeyMappings keyMappings = Internal.getKeyMappings();
				if (keyMappings.getCopyRecipeId().isActiveAndMatches(key)) {
					if (handleCopyRecipeId(recipeLayout, simulate)) {
						return Optional.of(this);
					}
				}
			}
			return Optional.empty();
		}

		private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout, boolean simulate) {
			if (simulate) {
				return true;
			}
			class_310 minecraft = class_310.method_1551();
			class_746 player = minecraft.field_1724;
			IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
			R recipe = recipeLayout.getRecipe();
			class_2960 registryName = recipeCategory.getRegistryName(recipe);
			if (registryName == null) {
				class_5250 message = class_2561.method_43471("jei.message.copy.recipe.id.failure");
				if (player != null) {
					player.method_7353(message, false);
				}
				return false;
			}

			String recipeId = registryName.toString();
			minecraft.field_1774.method_1455(recipeId);
			class_5250 message = class_2561.method_43469("jei.message.copy.recipe.id.success", class_2561.method_43470(recipeId));
			if (player != null) {
				player.method_7353(message, false);
			}
			return true;
		}

		@Override
		public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaX, double scrollDeltaY) {
			if (recipeLayout.isMouseOver(mouseX, mouseY) &&
				recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDeltaX, scrollDeltaY)
			) {
				return Optional.of(this);
			}

			return Optional.empty();
		}
	}
}
