package mezz.jei.library.plugins.vanilla.crafting.replacers;

import mezz.jei.api.constants.ModIds;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_7710;
import net.minecraft.class_8786;
import java.util.Arrays;
import java.util.List;

public final class ShulkerBoxColoringRecipeMaker {
	private static final String group = "jei.shulker.color";

	public static List<class_8786<class_3955>> createRecipes() {
		class_1856 baseShulkerIngredient = class_1856.method_8091(class_2246.field_10603);
		return Arrays.stream(class_1767.values())
			.map(color -> createRecipe(color, baseShulkerIngredient))
			.toList();
	}

	private static class_8786<class_3955> createRecipe(class_1767 color, class_1856 baseShulkerIngredient) {
		IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
		class_1856 colorIngredient = ingredientHelper.createShulkerDyeIngredient(color);
		class_2371<class_1856> inputs = class_2371.method_10212(class_1856.field_9017, baseShulkerIngredient, colorIngredient);
		class_2248 coloredShulkerBox = class_2480.method_10525(color);
		class_1799 output = new class_1799(coloredShulkerBox);
		class_2960 id = class_2960.method_60655(ModIds.MINECRAFT_ID, group + "." + output.method_7922());
		class_3955 recipe = new class_1867(group, class_7710.field_40251, output, inputs);
		return new class_8786<>(id, recipe);
	}

	private ShulkerBoxColoringRecipeMaker() {

	}
}
