package mezz.jei.gui.overlay.bookmarks;

import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.minecraft.class_1703;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_746;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public class PreviewTooltipComponent<R> implements class_5684, class_5632 {
	private static final int UPDATE_INTERVAL_MS = 2000;

	private final IRecipeLayoutDrawable<R> drawable;
	private @Nullable IRecipeTransferError transferError;
	private long lastUpdateTime = 0;

	public PreviewTooltipComponent(IRecipeLayoutDrawable<R> drawable) {
		this.drawable = drawable;
	}

	@Override
	public int method_32661() {
		return drawable.getRect().method_3320() + 10;
	}

	@Override
	public int method_32664(class_327 font) {
		return drawable.getRect().method_3319() + 4;
	}

	@Override
	public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
		class_4587 pose = guiGraphics.method_51448();
		pose.method_22903();
		{
			pose.method_46416(x + 2, y + 5, 0);
			drawable.drawRecipe(guiGraphics, 0, 0);
			updateTransferError();
			if (transferError != null) {
				class_768 recipeRect = drawable.getRect();
				transferError.showError(guiGraphics, x, y, drawable.getRecipeSlotsView(), recipeRect.method_3321(), recipeRect.method_3322());
			}
		}
		pose.method_22909();
	}

	private void updateTransferError() {
		long currentTime = System.currentTimeMillis();
		if (currentTime - lastUpdateTime < UPDATE_INTERVAL_MS) {
			return;
		}
		lastUpdateTime = currentTime;

		class_310 minecraft = class_310.method_1551();
		class_746 player = minecraft.field_1724;
		if (player == null) {
			transferError = null;
			return;
		}
		class_437 screen = class_310.method_1551().field_1755;
		if (screen instanceof class_465<?> containerScreen) {
			class_1703 container = containerScreen.method_17577();
			IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
			transferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, drawable, player)
				.orElse(null);
		} else {
			transferError = null;
		}
	}
}
