package mezz.jei.library.plugins.vanilla.cooking;

import com.mojang.serialization.Codec;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1874;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8786;

public abstract class AbstractCookingCategory<T extends class_1874> extends AbstractRecipeCategory<class_8786<T>> {
	protected final int regularCookTime;

	public AbstractCookingCategory(IGuiHelper guiHelper, RecipeType<class_8786<T>> recipeType, class_2248 icon, String translationKey, int regularCookTime) {
		this(guiHelper, recipeType, icon, translationKey, regularCookTime, 82, 54);
	}

	public AbstractCookingCategory(IGuiHelper guiHelper, RecipeType<class_8786<T>> recipeType, class_2248 icon, String translationKey, int regularCookTime, int width, int height) {
		super(
			recipeType,
			class_2561.method_43471(translationKey),
			guiHelper.createDrawableItemLike(icon),
			width,
			height
		);
		this.regularCookTime = regularCookTime;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
		T recipe = recipeHolder.comp_1933();

		builder.addInputSlot(1, 1)
			.setStandardSlotBackground()
			.addIngredients(recipe.method_8117().getFirst());

		builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37)
			.setStandardSlotBackground();

		builder.addOutputSlot(61, 19)
			.setOutputSlotBackground()
			.addItemStack(RecipeUtil.getResultItem(recipe));
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
		T recipe = recipeHolder.comp_1933();
		int cookTime = recipe.method_8167();
		if (cookTime <= 0) {
			cookTime = regularCookTime;
		}
		builder.addAnimatedRecipeArrow(cookTime)
			.setPosition(26, 17);
		builder.addAnimatedRecipeFlame(300)
			.setPosition(1, 20);

		addExperience(builder, recipeHolder);
		addCookTime(builder, recipeHolder);
	}

	protected void addExperience(IRecipeExtrasBuilder builder, class_8786<T> recipeHolder) {
		T recipe = recipeHolder.comp_1933();
		float experience = recipe.method_8171();
		if (experience > 0) {
			class_2561 experienceString = class_2561.method_43469("gui.jei.category.smelting.experience", experience);
			builder.addText(experienceString, getWidth() - 20, 10)
				.setPosition(0, 0, getWidth(), getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)
				.setTextAlignment(HorizontalAlignment.RIGHT)
				.setColor(0xFF808080);
		}
	}

	protected void addCookTime(IRecipeExtrasBuilder builder, class_8786<T> recipeHolder) {
		T recipe = recipeHolder.comp_1933();
		int cookTime = recipe.method_8167();
		if (cookTime <= 0) {
			cookTime = regularCookTime;
		}
		if (cookTime > 0) {
			int cookTimeSeconds = cookTime / 20;
			class_2561 timeString = class_2561.method_43469("gui.jei.category.smelting.time.seconds", cookTimeSeconds);
			builder.addText(timeString, getWidth() - 20, 10)
				.setPosition(0, 0, getWidth(), getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)
				.setTextAlignment(HorizontalAlignment.RIGHT)
				.setTextAlignment(VerticalAlignment.BOTTOM)
				.setColor(0xFF808080);
		}
	}

	@Override
	public boolean isHandled(class_8786<T> recipeHolder) {
		T recipe = recipeHolder.comp_1933();
		return !recipe.method_8118();
	}

	@Override
	public class_2960 getRegistryName(class_8786<T> recipe) {
		return recipe.comp_1932();
	}

	@Override
	public Codec<class_8786<T>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
		return codecHelper.getRecipeHolderCodec();
	}
}
