package mezz.jei.gui.recipes;

import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.common.util.StringUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class RecipeCategoryTitle {
	private final class_2561 visibleString;
	private final class_2561 fullString;
	private final ImmutableRect2i area;

	public static RecipeCategoryTitle create(IRecipeCategory<?> recipeCategory, class_327 font, ImmutableRect2i availableArea) {
		class_2561 fullString = StringUtil.stripStyling(recipeCategory.getTitle());
		class_2561 visibleString;

		final int availableTitleWidth = availableArea.getWidth();
		if (font.method_27525(fullString) > availableTitleWidth) {
			visibleString = StringUtil.truncateStringToWidth(fullString, availableTitleWidth, font);
		} else {
			visibleString = fullString;
		}

		ImmutableRect2i area = MathUtil.centerTextArea(availableArea, font, visibleString);
		return new RecipeCategoryTitle(visibleString, fullString, area);
	}

	public RecipeCategoryTitle() {
		this(class_2561.method_43473(), class_2561.method_43473(), ImmutableRect2i.EMPTY);
	}

	public RecipeCategoryTitle(class_2561 visibleString, class_2561 fullString, ImmutableRect2i area) {
		this.visibleString = visibleString;
		this.fullString = fullString;
		this.area = area;
	}

	public boolean isMouseOver(double mouseX, double mouseY) {
		return area.contains(mouseX, mouseY);
	}

	public void getTooltip(JeiTooltip tooltip) {
		if (!visibleString.equals(fullString)) {
			tooltip.add(fullString);
		}
	}

	public void draw(class_332 guiGraphics, class_327 font) {
		StringUtil.drawCenteredStringWithShadow(guiGraphics, font, visibleString, area);
	}
}
