package mezz.jei.library.plugins.vanilla.stonecutting;

import com.mojang.serialization.Codec;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3975;
import net.minecraft.class_8786;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.common.Constants;

public class StoneCuttingRecipeCategory implements IRecipeCategory<class_8786<class_3975>> {
	public static final int width = 82;
	public static final int height = 34;

	private final IDrawable background;
	private final IDrawable icon;
	private final class_2561 localizedName;

	public StoneCuttingRecipeCategory(IGuiHelper guiHelper) {
		class_2960 location = Constants.RECIPE_GUI_VANILLA;
		background = guiHelper.createDrawable(location, 0, 220, width, height);
		icon = guiHelper.createDrawableItemStack(new class_1799(class_2246.field_16335));
		localizedName = class_2561.method_43471("gui.jei.category.stoneCutter");
	}

	@Override
	public RecipeType<class_8786<class_3975>> getRecipeType() {
		return RecipeTypes.STONECUTTING;
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<class_3975> recipeHolder, IFocusGroup focuses) {
		class_3975 recipe = recipeHolder.comp_1933();

		builder.addSlot(RecipeIngredientRole.INPUT, 1, 9)
			.addIngredients(recipe.method_8117().getFirst());

		builder.addSlot(RecipeIngredientRole.OUTPUT, 61,  9)
			.addItemStack(RecipeUtil.getResultItem(recipe));
	}

	@Override
	public boolean isHandled(class_8786<class_3975> recipeHolder) {
		class_3975 recipe = recipeHolder.comp_1933();
		return !recipe.method_8118();
	}

	@Override
	public class_2960 getRegistryName(class_8786<class_3975> recipe) {
		return recipe.comp_1932();
	}

	@Override
	public Codec<class_8786<class_3975>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
		return codecHelper.getRecipeHolderCodec();
	}
}
