package mezz.jei.library.plugins.vanilla.crafting.replacers;

import mezz.jei.api.constants.ModIds;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_7710;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import java.util.List;

public final class TippedArrowRecipeMaker {

	public static List<class_8786<class_3955>> createRecipes(IJeiHelpers jeiHelpers) {
		IStackHelper stackHelper = jeiHelpers.getStackHelper();
		IVanillaRecipeFactory vanillaRecipeFactory = jeiHelpers.getVanillaRecipeFactory();

		String group = "jei.tipped.arrow";
		class_1799 arrowStack = new class_1799(class_1802.field_8107);
		class_1856 arrowIngredient = class_1856.method_8101(arrowStack);

		class_2378<class_1842> potionRegistry = RegistryUtil.getRegistry(class_7924.field_41215);
		IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
		return potionRegistry.method_40270()
			.map(potion -> {
				class_1799 input = class_1844.method_57400(class_1802.field_8150, potion);
				class_1799 output = class_1844.method_57400(class_1802.field_8087, potion);
				output.method_7939(8);

				class_1856 potionIngredient = class_1856.method_8101(input);
				class_2960 id = class_2960.method_60655(ModIds.MINECRAFT_ID, "jei.tipped.arrow." + output.method_7922());
				class_3955 recipe = vanillaRecipeFactory.createShapedRecipeBuilder(class_7710.field_40251, List.of(output))
					.group(group)
					.define('a', arrowIngredient)
					.define('p', potionIngredient)
					.pattern("aaa")
					.pattern("apa")
					.pattern("aaa")
					.build();
				return new class_8786<>(id, recipe);
			})
			.toList();
	}

	private TippedArrowRecipeMaker() {

	}
}
