package mezz.jei.library.plugins.vanilla.cooking;

import com.mojang.serialization.Codec;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.common.Constants;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1874;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8029;
import net.minecraft.class_8786;

import static mezz.jei.api.recipe.RecipeIngredientRole.INPUT;
import static mezz.jei.api.recipe.RecipeIngredientRole.OUTPUT;

public abstract class AbstractCookingCategory<T extends class_1874> extends FurnaceVariantCategory<class_8786<T>> {
	private final IDrawable background;
	private final IDrawable icon;
	private final class_2561 localizedName;
	protected final IGuiHelper guiHelper;
	protected final int regularCookTime;

	public AbstractCookingCategory(IGuiHelper guiHelper, class_2248 icon, String translationKey, int regularCookTime) {
		super(guiHelper);
		this.background = guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 114, 82, 54);
		this.regularCookTime = regularCookTime;
		this.icon = guiHelper.createDrawableItemStack(new class_1799(icon));
		this.localizedName = class_2561.method_43471(translationKey);
		this.guiHelper = guiHelper;
	}

	@Override
	public IDrawable getBackground() {
		return background;
	}

	@Override
	public IDrawable getIcon() {
		return icon;
	}

	@Override
	public void draw(class_8786<T> recipeHolder, IRecipeSlotsView recipeSlotsView, class_332 guiGraphics, double mouseX, double mouseY) {
		animatedFlame.draw(guiGraphics, 1, 20);

		drawExperience(recipeHolder, guiGraphics, 0);
		drawCookTime(recipeHolder, guiGraphics, 45);
	}

	protected void drawExperience(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
		T recipe = recipeHolder.comp_1933();
		float experience = recipe.method_8171();
		if (experience > 0) {
			class_2561 experienceString = class_2561.method_43469("gui.jei.category.smelting.experience", experience);
			class_310 minecraft = class_310.method_1551();
			class_327 fontRenderer = minecraft.field_1772;
			int stringWidth = fontRenderer.method_27525(experienceString);
			guiGraphics.method_51439(fontRenderer, experienceString, getWidth() - stringWidth, y, 0xFF808080, false);
		}
	}

	protected void drawCookTime(class_8786<T> recipeHolder, class_332 guiGraphics, int y) {
		T recipe = recipeHolder.comp_1933();
		int cookTime = recipe.method_8167();
		if (cookTime > 0) {
			int cookTimeSeconds = cookTime / 20;
			class_2561 timeString = class_2561.method_43469("gui.jei.category.smelting.time.seconds", cookTimeSeconds);
			class_310 minecraft = class_310.method_1551();
			class_327 fontRenderer = minecraft.field_1772;
			int stringWidth = fontRenderer.method_27525(timeString);
			guiGraphics.method_51439(fontRenderer, timeString, getWidth() - stringWidth, y, 0xFF808080, false);
		}
	}

	@Override
	public class_2561 getTitle() {
		return localizedName;
	}

	@Override
	public void setRecipe(IRecipeLayoutBuilder builder, class_8786<T> recipeHolder, IFocusGroup focuses) {
		T recipe = recipeHolder.comp_1933();

		builder.addSlot(INPUT, 1, 1)
			.addIngredients(recipe.method_8117().getFirst());

		builder.addSlot(OUTPUT, 61, 19)
			.addItemStack(RecipeUtil.getResultItem(recipe));
	}

	@Override
	public void createRecipeExtras(IRecipeExtrasBuilder acceptor, class_8786<T> recipeHolder, IFocusGroup focuses) {
		acceptor.addWidget(createCookingArrowWidget(recipeHolder, new class_8029(24, 18)));
	}

	@Override
	public boolean isHandled(class_8786<T> recipeHolder) {
		T recipe = recipeHolder.comp_1933();
		return !recipe.method_8118();
	}

	@Override
	public class_2960 getRegistryName(class_8786<T> recipe) {
		return recipe.comp_1932();
	}

	@Override
	public Codec<class_8786<T>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
		return codecHelper.getRecipeHolderCodec();
	}

	protected IRecipeWidget createCookingArrowWidget(class_8786<T> recipeHolder, class_8029 position) {
		return new CookingArrowRecipeWidget<>(guiHelper, recipeHolder, regularCookTime, position);
	}

	private static class CookingArrowRecipeWidget<T extends class_1874> implements IRecipeWidget {
		private final IDrawableAnimated arrow;
		private final class_8029 position;

		public CookingArrowRecipeWidget(IGuiHelper guiHelper, class_8786<T> recipeHolder, int regularCookTime, class_8029 position) {
			T recipe = recipeHolder.comp_1933();
			int cookTime = recipe.method_8167();
			if (cookTime <= 0) {
				cookTime = regularCookTime;
			}
			this.arrow = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 128, 24, 17)
				.buildAnimated(cookTime, IDrawableAnimated.StartDirection.LEFT, false);
			this.position = position;
		}

		@Override
		public class_8029 getPosition() {
			return position;
		}

		@Override
		public void draw(class_332 guiGraphics, double mouseX, double mouseY) {
			arrow.draw(guiGraphics);
		}
	}
}
