package mezz.jei.library.ingredients.itemStacks;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import java.util.Optional;

public record TypedItemStack(
	class_6880<class_1792> itemHolder,
	class_9326 dataComponentPatch,
	int count
) implements ITypedIngredient<class_1799> {
	public static ITypedIngredient<class_1799> create(class_1799 ingredient) {
		if (ingredient.method_7947() == 1) {
			return NormalizedTypedItemStack.create(ingredient);
		}
		return new TypedItemStack(
			ingredient.method_41409(),
			ingredient.method_57380(),
			ingredient.method_7947()
		);
	}

	@Override
	public class_1799 getIngredient() {
		return new class_1799(itemHolder, count, dataComponentPatch);
	}

	@Override
	public Optional<class_1799> getItemStack() {
		return Optional.of(getIngredient());
	}

	@Override
	public IIngredientType<class_1799> getType() {
		return VanillaTypes.ITEM_STACK;
	}

	@Override
	public String toString() {
		return "TypedItemStack{" +
			"itemHolder=" + itemHolder +
			", dataComponentPatch=" + dataComponentPatch +
			", count=" + count +
			'}';
	}
}
