package mezz.jei.library.ingredients.itemStacks;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import java.util.Optional;

public record NormalizedTypedItemStack(
	class_6880<class_1792> itemHolder,
	class_9326 dataComponentPatch
) implements ITypedIngredient<class_1799> {
	public static ITypedIngredient<class_1799> normalize(ITypedIngredient<class_1799> typedIngredient) {
		switch (typedIngredient) {
			case NormalizedTypedItemStack normalized -> {
				return normalized;
			}
			case NormalizedTypedItem normalized -> {
				return normalized;
			}
			case TypedItemStack typedItemStack -> {
				return create(typedItemStack.itemHolder(), typedItemStack.dataComponentPatch());
			}
			default -> {
				ItemStack itemStack = typedIngredient.getIngredient();
				return create(itemStack.getItemHolder(), itemStack.getComponentsPatch());
			}
		}
	}

	public static ITypedIngredient<class_1799> create(class_6880<class_1792> itemHolder, class_9326 dataComponentPatch) {
		if (dataComponentPatch.method_57848()) {
			return new NormalizedTypedItem(itemHolder);
		}
		return new NormalizedTypedItemStack(itemHolder, dataComponentPatch);
	}

	public static ITypedIngredient<class_1799> create(class_1799 itemStack) {
		return create(
			itemStack.method_41409(),
			itemStack.method_57380()
		);
	}

	@Override
	public class_1799 getIngredient() {
		return new class_1799(itemHolder, 1, dataComponentPatch);
	}

	@Override
	public Optional<class_1799> getItemStack() {
		return Optional.of(getIngredient());
	}

	@Override
	public IIngredientType<class_1799> getType() {
		return VanillaTypes.ITEM_STACK;
	}

	@Override
	public String toString() {
		return "NormalizedTypedItemStack{" +
			"itemHolder=" + itemHolder +
			", dataComponentPatch=" + dataComponentPatch +
			'}';
	}
}
